package com.agilex.healthcare.mobilehealthplatform.datalayer.vista.patient;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.Ignore;

import com.agilex.healthcare.mobilehealthplatform.datalayer.patient.PatientSupplementalDemographicsDataLayerMdws;
import com.agilex.healthcare.mobilehealthplatform.domain.Address;
import com.agilex.healthcare.mobilehealthplatform.domain.Addresses;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientDemographics;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.mdws.MdwsIntegrationTestHelper;
import com.agilex.healthcare.mobilehealthplatform.mdws.VistaTest;

@Ignore("TODO: ensure data consistency with MDWS / test vista site")
public class PatientDemographicsMdwsVistaTest extends VistaTest{

	private PatientSupplementalDemographicsDataLayerMdws dataLayer;

	@Before
	public void setup(){
		dataLayer = new PatientSupplementalDemographicsDataLayerMdws(MdwsIntegrationTestHelper.getInternalMdwsConfiguration());
	}

	@Test
	public void validateFetch() {
		PatientDemographics supplementalDemographics = dataLayer.fetchPatientContactInformation(new PatientIdentifier("dfn-500", "100844"));
		Assert.assertNotNull(supplementalDemographics);
		Assert.assertEquals("GALLOW.YOUNGER@VA.CM", supplementalDemographics.getEmailAddress());
		Assert.assertEquals("(703)-889-3902", supplementalDemographics.getPhoneNumberHome());
		Assert.assertEquals("(703)-555-2222", supplementalDemographics.getPhoneNumberWork());
		Assert.assertEquals("(703)-307-5555", supplementalDemographics.getPhoneNumberMobile());

		Addresses addresses = supplementalDemographics.getAddresses();
		Assert.assertEquals(1, addresses.size());
		Address address = addresses.get(0);
		Assert.assertEquals("345 Tester Lane", address.getStreetAddressLine1());
		Assert.assertEquals("APT. 123", address.getStreetAddressLine2());
		Assert.assertEquals("P.O. Box 1234", address.getStreetAddressLine3());
		Assert.assertEquals("CHANTILLY", address.getCity());
		Assert.assertEquals("VIRGINIA", address.getState());
		Assert.assertEquals("20151", address.getZipCode());

	}

}
