package com.agilex.healthcare.mobilehealthplatform.datalayer.vista.patient;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import org.junit.Before;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.datalayer.patient.PatientDataLayerMdws;
import com.agilex.healthcare.mobilehealthplatform.datalayer.patient.PatientSearchCriteria;
import com.agilex.healthcare.mobilehealthplatform.domain.Address;
import com.agilex.healthcare.mobilehealthplatform.domain.Patient;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientDemographics;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.Patients;
import com.agilex.healthcare.mobilehealthplatform.mdws.MdwsIntegrationTestHelper;
import com.agilex.healthcare.mobilehealthplatform.mdws.VistaTest;

public class PatientDataLayerMdwsVistaTest extends VistaTest{

	private PatientDataLayerMdws dao;

	@Before
	public void setup(){
		dao = new PatientDataLayerMdws(MdwsIntegrationTestHelper.getInternalMdwsConfiguration());
	}
	
	@Test
	public void testGetDemographicsFor237() {
		PatientDemographics patient = dao.getDemographics(new PatientIdentifier("dfn-500", "237"));
		assertNotNull(patient);
		
		assertEquals("(222)-555-8235", patient.getPhoneNumberHome());
		assertEquals("(222)-555-7720", patient.getPhoneNumberWork());
		
		Address address = patient.getAddress();
		assertEquals("99998", address.getZipCode());
		assertEquals("WEST VIRGINIA", address.getState());
		assertEquals("Any Town", address.getCity());
		assertEquals("Any Street", address.getStreetAddressLine1());
	}
	
	@Test
	public void testGetPatient8() {
		Patient patient = dao.getPatient(new PatientIdentifier("dfn-500", "8"));
		assertNotNull(patient);
		
		assertEquals("PATIENT", patient.getFirstName());
		assertEquals("TEN", patient.getLastName());
		assertEquals("TEN,PATIENT", patient.getDisplayName());
		assertEquals("M", patient.getGender());
		assertEquals("666000010", patient.getSsn());
		String dateOfBirth = patient.getDateOfBirth().toString();
		assertEquals("Apr 07, 1935", dateOfBirth);
	}

	@Test
	public void testGetPatientsViaMatchSearchString() {
		PatientSearchCriteria criteria = new PatientSearchCriteria();
		criteria.setVistaSiteCode("500");
		criteria.setSearchString("TEN");
		Patients patients = dao.patientSearch(criteria);
		
		assertNotNull(patients);
		assertEquals(44, patients.size());
	}

	@Test
	public void testGetPatientsViaPrototypeLastName() {
        Patient patientPrototype  = new Patient();
        patientPrototype.setLastName("TEN");

        PatientSearchCriteria criteria = new PatientSearchCriteria();
        criteria.setVistaSiteCode("500");
        criteria.setPrototype(patientPrototype);

		Patients patients = dao.patientSearch(criteria);

		assertNotNull(patients);
		assertEquals(4, patients.size());
	}

	@Test
	public void testGetPatientsViaPrototypeLastNameFirstName() {
        Patient patientPrototype  = new Patient();
        patientPrototype.setLastName("TEN");
        patientPrototype.setFirstName("Image");

        PatientSearchCriteria criteria = new PatientSearchCriteria();
        criteria.setVistaSiteCode("500");
        criteria.setPrototype(patientPrototype);

		Patients patients = dao.patientSearch(criteria);

		assertNotNull(patients);
		assertEquals(1, patients.size());
        assertEquals("TEN,IMAGEPATIENT", patients.get(0).getDisplayName());
	}

	@Test
	public void testGetPatientsWithSSN(){
		PatientSearchCriteria criteria = new PatientSearchCriteria();
		criteria.setVistaSiteCode("500");
		criteria.setSearchString("666000001");
		Patients patients = dao.patientSearch(criteria);
		
		assertNotNull(patients);
		assertEquals(1, patients.size());

	}
}
