package com.agilex.healthcare.mobilehealthplatform.datalayer.vista.medication.rxrefill;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.datalayer.medication.rxrefill.MedicationRefillDataLayerMdws;
import com.agilex.healthcare.mobilehealthplatform.domain.Medication;
import com.agilex.healthcare.mobilehealthplatform.domain.Medications;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.mdws.MdwsIntegrationTestHelper;
import com.agilex.healthcare.mobilehealthplatform.mdws.VistaTest;
import com.agilex.healthcare.mobilehealthplatform.mdws.soapconsumer.MhvMdwsConfiguration;

@Ignore("TODO: ensure data consistency with MDWS / test vista site")
public class MedicationRefillDataLayerMdwsTest extends VistaTest{

	MhvMdwsConfiguration configuration;

	String patientWithMedications = "5000000109V251288";
	String patientWithoutMedications = "5000000108V251288";
	PatientIdentifier patientIdentifier;

	@Before
	public void before() {
		configuration = MdwsIntegrationTestHelper.getInternalMhvConfigurationForMedicationRefill();
		patientIdentifier = new PatientIdentifier("dfn-500", patientWithMedications);
	}

    @Ignore
	@Test
	public void validateRetrieval() {
		MedicationRefillDataLayerMdws dataLayer = new MedicationRefillDataLayerMdws(configuration);

		Medications medications = dataLayer.fetchMedications(patientIdentifier);
		Assert.assertNotNull(medications);
		Assert.assertTrue(medications.size() > 0);

		Medication medication = medications.get(0);
		Assert.assertNotNull(medication.getDrugName());
		Assert.assertNotNull(medication.getSig());
		Assert.assertNotNull(medication.getExpiredDate());
		Assert.assertNotNull(medication.getStatus());
		Assert.assertNotNull(medication.getRefills());
		Assert.assertNotNull(medication.getLastFilledDate());
		Assert.assertNotNull(medication.getUniqueId());
		Assert.assertNotNull(medication.getPrescriptionId());
		Assert.assertNotNull(medication.getRefillAction());
	}

	@Test
	public void validateBehaviorForPatientWithoutMedications() {
		MedicationRefillDataLayerMdws dataLayer = new MedicationRefillDataLayerMdws(configuration);
		PatientIdentifier identifierWithoutMedications = new PatientIdentifier("dfn-500", patientWithoutMedications);
		Medications medications = dataLayer.fetchMedications(identifierWithoutMedications);

		Assert.assertNotNull(medications);
		Assert.assertEquals(0, medications.size());
	}

    @Ignore
	@Test
	public void validateFillMedication() {
		MedicationRefillDataLayerMdws dataLayer = new MedicationRefillDataLayerMdws(configuration);
		Medications medications = dataLayer.fetchMedications(patientIdentifier);
		Medication medication = medications.get(0);
		medication.setPatientIdentifier(patientIdentifier);
		Medication refill = dataLayer.refillMedication(medication);
		Assert.assertNotNull(refill);
	}

}
