package com.agilex.healthcare.mobilehealthplatform.datalayer.vista.medication;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import javax.annotation.Resource;

import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import com.agilex.healthcare.mobilehealthplatform.datalayer.medication.MedicationDataLayerMdws;
import com.agilex.healthcare.mobilehealthplatform.datalayer.medication.MedicationFilter;
import com.agilex.healthcare.mobilehealthplatform.domain.Medication;
import com.agilex.healthcare.mobilehealthplatform.domain.Medications;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.mdws.VistaTest;
import com.agilex.healthcare.mobilehealthplatform.mdws.soapconsumer.MdwsConfiguration;

@Ignore("TODO: ensure data consistency with MDWS / test vista site")
@ContextConfiguration(locations = { "classpath:integrationApplicationContext.xml" })
@RunWith(SpringJUnit4ClassRunner.class)
public class MedicationDataLayerMdwsVistaTest extends VistaTest{

	@Resource
	MdwsConfiguration mdwsVistaConfiguration;
	private MedicationDataLayerMdws dl;

	@Before
	public void setup() {
		dl = new MedicationDataLayerMdws(mdwsVistaConfiguration);
	}

	private static final String TEST_PATIENT_ID = "100608";
	private static final String TEST_MEDICATION_ID = "404209R;O";

	private PatientIdentifier createPid() {
		PatientIdentifier pId = new PatientIdentifier();
		pId.setAssigningAuthority("dfn-500");
		pId.setUniqueId(TEST_PATIENT_ID);
		return pId;
	}

	@Test
	public void verifyFetchMedications() {
		Medications medications = dl.getMedications(createPid(), false);

		assertTrue(String.format("Zero medications were found for patient [id: %s]", TEST_PATIENT_ID), medications.size() > 0);
	}

	@Ignore
	public void verifyFetchMedicationsByFilter() {
		MedicationFilter filter = new MedicationFilter();
		filter.addStatus("EXPIRED");
		Medications medications = dl.getMedications(createPid(), filter);

		assertTrue(String.format("Zero medications were found for patient [id: %s]", TEST_PATIENT_ID), medications.size() == 0);
	}

    @Ignore
	@Test
	public void testGetMedicationLite() {
		Medication medication = dl.getMedicationLite(createPid(), TEST_MEDICATION_ID);
		assertNotNull(medication);
		assertEquals(TEST_MEDICATION_ID, medication.getId());
	}

}
