package com.agilex.healthcare.mobilehealthplatform.datalayer.vista.lab;

import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import javax.annotation.Resource;

import org.junit.Test;
import org.junit.Ignore;
import org.junit.runner.RunWith;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import com.agilex.healthcare.mobilehealthplatform.datalayer.lab.MicrobiologyLabDataLayerMdws;
import com.agilex.healthcare.mobilehealthplatform.domain.LabResults;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilterImpl;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.MutableDateFilter;
import com.agilex.healthcare.mobilehealthplatform.mdws.VistaTest;
import com.agilex.healthcare.mobilehealthplatform.mdws.soapconsumer.MdwsConfiguration;
import com.agilex.healthcare.utility.DateHelper;

@Ignore("TODO: ensure data consistency with MDWS / test vista site")
@ContextConfiguration(locations = { "classpath:integrationApplicationContext.xml"})
@RunWith(SpringJUnit4ClassRunner.class)
public class MicrobiologyLabDataLayerMdwsVistaTest extends VistaTest{

	@Resource
	MdwsConfiguration mdwsVistaConfiguration;

	private final String testStartDate = "01/01/1990";
	private final String testEndDate = "12/31/2012";

    private PatientIdentifier createPatientIdentifier() {
        PatientIdentifier patientIdentifier = new PatientIdentifier();
        patientIdentifier.setAssigningAuthority("dfn-500");
        patientIdentifier.setUniqueId("237");
        return patientIdentifier;
    }

	@Test
	public void validateRetrieveLabResultsFromVISTA() {
		PatientIdentifier pId = createPatientIdentifier();
		MicrobiologyLabDataLayerMdws datalayer = new MicrobiologyLabDataLayerMdws(mdwsVistaConfiguration);
		LabResults results = datalayer.getLabResults(pId, createDateFilter());
		assertNotNull(results);
		assertTrue(String.format("Results count: %s", results.size()), results.size() >= 7);
		assertTrue(!results.get(0).getTestname().isEmpty());
	}

	@Test
	public void validateRetrieveLabResultsFromVISTAForNullDates() {
		PatientIdentifier pId = createPatientIdentifier();
		MicrobiologyLabDataLayerMdws datalayer = new MicrobiologyLabDataLayerMdws(mdwsVistaConfiguration);
		LabResults results = datalayer.getLabResults(pId, createNullDateFilter());
		assertNotNull(results);
		assertTrue(String.format("Results count: %s", results.size()), results.size() >= 7);
		assertTrue(!results.get(0).getTestname().isEmpty());
	}

	private DateFilter createNullDateFilter() {
		MutableDateFilter dateFilter = new DateFilterImpl();
		dateFilter.setStartDate(null);
		dateFilter.setEndDate(null);
		return dateFilter;
	}

	private DateFilter createDateFilter() {
		MutableDateFilter dateFilter = new DateFilterImpl();
		dateFilter.setStartDate(DateHelper.parseDate(testStartDate ));
		dateFilter.setEndDate(DateHelper.parseDate(testEndDate));
		return dateFilter;
	}

}
