package com.agilex.healthcare.mobilehealthplatform.datalayer.vista.lab;

import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.fail;

import java.net.SocketTimeoutException;

import javax.annotation.Resource;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import com.agilex.healthcare.mobilehealthplatform.datalayer.lab.ChemistryLabDataLayerMdws;
import com.agilex.healthcare.mobilehealthplatform.domain.LabResults;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilterImpl;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.MutableDateFilter;
import com.agilex.healthcare.mobilehealthplatform.mdws.VistaTest;
import com.agilex.healthcare.mobilehealthplatform.mdws.soapconsumer.MdwsConfiguration;
import com.agilex.healthcare.mobilehealthplatform.mdws.soapconsumer.MhvMdwsConfiguration;
import com.agilex.healthcare.utility.DateHelper;

@ContextConfiguration(locations = {"classpath:integrationApplicationContext.xml"})
@RunWith(SpringJUnit4ClassRunner.class)
public class DataLayerMdwsVistaTestData extends VistaTest{
    private static final org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(DataLayerMdwsVistaTestData.class);


    @Resource
    MdwsConfiguration mdwsVistaConfiguration;

    @Resource
    MhvMdwsConfiguration mdwsMhvConfiguration;

    private final String testStartDate = "01/01/1990";
    private final String testEndDate = "12/31/2012";

    
    private PatientIdentifier createPatientIdentifier() {
        PatientIdentifier patientIdentifier = new PatientIdentifier();
        patientIdentifier.setAssigningAuthority("dfn-500");
        patientIdentifier.setUniqueId("237");
        return patientIdentifier;
    }

    @Test
    public void validateRetrieveLabResultsTimeoutFromVISTA() {
    		PatientIdentifier pId = createPatientIdentifier();
        int connectTimeout = mdwsVistaConfiguration.getWsConnectTimeout();
        int reqTimout = mdwsVistaConfiguration.getWsRequestTimeout();
        try {
            mdwsVistaConfiguration.setWsConnectTimeout(1);
            mdwsVistaConfiguration.setWsRequestTimeout(1);
            ChemistryLabDataLayerMdws datalayer = new ChemistryLabDataLayerMdws(mdwsVistaConfiguration);
            LabResults results = datalayer.getLabResults(pId, createDateFilter());
            assertNotNull(results);
            fail("web service timeout did not kick in");
        } catch (Exception e) {
            if (!(e.getCause() instanceof SocketTimeoutException))
                fail("web service timeout test failed");
        } finally {
            mdwsVistaConfiguration.setWsConnectTimeout(connectTimeout);
            mdwsVistaConfiguration.setWsRequestTimeout(reqTimout);
        }
    }

    private DateFilter createDateFilter() {
        MutableDateFilter dateFilter = new DateFilterImpl();
        dateFilter.setStartDate(DateHelper.parseDate(testStartDate));
        dateFilter.setEndDate(DateHelper.parseDate(testEndDate));
        return dateFilter;
    }

}