package com.agilex.healthcare.mobilehealthplatform.datalayer.vista.lab;

import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import java.util.HashSet;
import java.util.Set;

import javax.annotation.Resource;

import org.junit.Test;
import org.junit.Ignore;
import org.junit.runner.RunWith;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import com.agilex.healthcare.mobilehealthplatform.datalayer.lab.ChemistryLabDataLayerMdws;
import com.agilex.healthcare.mobilehealthplatform.domain.LabResult;
import com.agilex.healthcare.mobilehealthplatform.domain.LabResults;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilterImpl;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.MutableDateFilter;
import com.agilex.healthcare.mobilehealthplatform.mdws.VistaTest;
import com.agilex.healthcare.mobilehealthplatform.mdws.soapconsumer.MdwsConfiguration;
import com.agilex.healthcare.utility.DateHelper;

@Ignore("TODO: ensure data consistency with MDWS / test vista site")
@ContextConfiguration(locations = { "classpath:integrationApplicationContext.xml"})
@RunWith(SpringJUnit4ClassRunner.class)
public class ChemistryLabDataLayerMdwsVistaTest extends VistaTest{

	@Resource
	MdwsConfiguration mdwsVistaConfiguration;

	private final String testSpecimenId = "6899785.899997";
	private final String testTestId = "173";
	private final String testStartDate = "01/01/1990";
	private final String testEndDate = "12/31/2012";

    private PatientIdentifier createPatientIdentifier() {
        PatientIdentifier patientIdentifier = new PatientIdentifier();
        patientIdentifier.setAssigningAuthority("dfn-500");
        patientIdentifier.setUniqueId("237");
        return patientIdentifier;
    }

	@Test
	public void validateRetrieveLabResultsFromVISTA() {
		ChemistryLabDataLayerMdws datalayer = new ChemistryLabDataLayerMdws(mdwsVistaConfiguration);
		PatientIdentifier pId = createPatientIdentifier();
		LabResults results = datalayer.getLabResults(pId, createDateFilter());
		Set<String> s = new HashSet<String>();
		for (LabResult labResult : results) {
			String id = labResult.getUniqueId();
			s.add(id);
		}
		//System.out.println(s);
		assertNotNull(results);
		//assertTrue(s.contains(testTestId));
		assertTrue(String.format("Results count: %s", results.size()), results.size() >= 69);
	}

	@Test
	public void validateRetrieveLabResultByTestIdFromVISTA() {
		ChemistryLabDataLayerMdws datalayer = new ChemistryLabDataLayerMdws(mdwsVistaConfiguration);
		LabResults results = datalayer.getLabResultsByTestId(createPatientIdentifier(), testTestId);
		Set<String> s = new HashSet<String>();
		for (LabResult labResult : results) {
			s.add(labResult.getSpecimenId());
		}

		assertNotNull(results);
		assertTrue(s.contains(testSpecimenId));
		assertTrue(String.format("Results count: %s", results.size()), results.size() >= 11);
	}

	private DateFilter createDateFilter() {
		MutableDateFilter dateFilter = new DateFilterImpl();
		dateFilter.setStartDate(DateHelper.parseDate(testStartDate ));
		dateFilter.setEndDate(DateHelper.parseDate(testEndDate));
		return dateFilter;
	}

}
