package com.agilex.healthcare.mobilehealthplatform.datalayer.vista.appointment;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import javax.annotation.Resource;

import org.junit.Test;
import org.junit.Ignore;
import org.junit.runner.RunWith;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import com.agilex.healthcare.mobilehealthplatform.datalayer.appointment.AppointmentDataLayerMdws;
import com.agilex.healthcare.mobilehealthplatform.datalayer.appointment.ClinicalNoteDataLayerMdws;
import com.agilex.healthcare.mobilehealthplatform.domain.Appointments;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.ProviderNote;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilterFactory;
import com.agilex.healthcare.mobilehealthplatform.mdws.VistaTest;
import com.agilex.healthcare.mobilehealthplatform.mdws.soapconsumer.MdwsConfiguration;

@Ignore("TODO: ensure data consistency with MDWS / test vista site")
@ContextConfiguration(locations = {"classpath:integrationApplicationContext.xml"})
@RunWith(SpringJUnit4ClassRunner.class)
public class ClinicNoteDataLayerMdwsVistaTest extends VistaTest{

	@Resource
    MdwsConfiguration mdwsVistaConfiguration;

	private PatientIdentifier patientIdentifier() {
        return new PatientIdentifier("DFN-500", "237");
    }

    private MdwsConfiguration getMdwsConfiguration() {
        return mdwsVistaConfiguration;
    }

	@Test
    public void verifyFetchAppointmentsReturnsClinicalNotes() {
        AppointmentDataLayerMdws dl = new AppointmentDataLayerMdws(getMdwsConfiguration());
        Appointments appointments = dl.fetchAppointmentsByPatient(patientIdentifier(), DateFilterFactory.createEmptyFilter(), true);
        assertNotNull(appointments);

        ClinicalNoteDataLayerMdws noteDataLayer = new ClinicalNoteDataLayerMdws(getMdwsConfiguration());
        ProviderNote clinicNote = noteDataLayer.fetchClinicalNote(patientIdentifier(), "A;3000521.08;23");

        String expectedNote =
                " LOCAL TITLE: CRISIS NOTE                                        \n" +
                "DATE OF NOTE: MAY 21, 2000@12:41     ENTRY DATE: MAY 21, 2000@12:41:26      \n" +
                "      AUTHOR: VEHU,ONE             EXP COSIGNER:                           \n" +
                "     URGENCY:                            STATUS: COMPLETED                     \n" +
                "\n" +
                "LETS SEE HOW THIS WORKS NOW\n" +
                " \n" +
                "/es/ ONE CAMP\n" +
                "\n" +
                "Signed: 05/21/2000 12:42\n" +
                " \n" +
                " \n";
        assertEquals(expectedNote, clinicNote.getText());
    }
}
