package com.agilex.healthcare.mobilehealthplatform.datalayer.vista.appointment;

import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import javax.annotation.Resource;

import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import com.agilex.healthcare.mobilehealthplatform.datalayer.appointment.AppointmentDataLayerMdws;
import com.agilex.healthcare.mobilehealthplatform.domain.Appointment;
import com.agilex.healthcare.mobilehealthplatform.domain.Appointments;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilterFactory;
import com.agilex.healthcare.mobilehealthplatform.mdws.VistaTest;
import com.agilex.healthcare.mobilehealthplatform.mdws.soapconsumer.MdwsConfiguration;

@ContextConfiguration(locations = {"classpath:integrationApplicationContext.xml"})
@RunWith(SpringJUnit4ClassRunner.class)
public class AppointmentDataLayerMdwsVistaTest extends VistaTest{

    @Resource
    MdwsConfiguration mdwsVistaConfiguration;

    private PatientIdentifier createPatientIdentifier() {
        PatientIdentifier patientIdentifier = new PatientIdentifier();
        patientIdentifier.setAssigningAuthority("dfn-500");
        patientIdentifier.setUniqueId("237");
        return patientIdentifier;
    }

    private MdwsConfiguration getMdwsConfiguration() {
        return mdwsVistaConfiguration;
    }

    @Test
    public void verifyFetchAppointments() {
        AppointmentDataLayerMdws dl = new AppointmentDataLayerMdws(getMdwsConfiguration());
        Appointments appointments = dl.fetchAppointmentsByPatient(createPatientIdentifier(), DateFilterFactory.createEmptyFilter());
        assertNotNull(appointments);
        assertTrue(String.format("Size was: %d", appointments.size()), appointments.size() > 50);
    }

    @Ignore("Not currently implemented")
    @Test
    public void verifyFetchMentalHealthAppointments() {
        AppointmentDataLayerMdws dl = new AppointmentDataLayerMdws(getMdwsConfiguration());
        Appointments appointments = dl.fetchMentalHealthAppointments(createPatientIdentifier(), DateFilterFactory.createEmptyFilter());
        assertNotNull(appointments);
        assertTrue(String.format("Size was: %d", appointments.size()), appointments.size() > 0);

        Appointment appointment = appointments.get(0);
        assertNotNull(appointment.getAppointmentStartDate());
        assertNotNull(appointment.getReasonForVisit());
        assertNotNull(appointment.getClinicName());
    }
}
