package com.agilex.healthcare.mobilehealthplatform.datalayer.vista.allergy;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import javax.annotation.Resource;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import com.agilex.healthcare.mobilehealthplatform.datalayer.allergy.AllergyDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.allergy.AllergyDataLayerMdws;
import com.agilex.healthcare.mobilehealthplatform.domain.Allergies;
import com.agilex.healthcare.mobilehealthplatform.domain.Allergy;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilterFactory;
import com.agilex.healthcare.mobilehealthplatform.mdws.VistaTest;
import com.agilex.healthcare.mobilehealthplatform.mdws.soapconsumer.MdwsConfiguration;
import com.agilex.healthcare.utility.DateHelper;

@ContextConfiguration(locations = { "classpath:integrationApplicationContext.xml"})
@RunWith(SpringJUnit4ClassRunner.class)
public class AllergyDataLayerMdwsVistaTest extends VistaTest{
	
	@Resource
	MdwsConfiguration mdwsVistaConfiguration;

	@Test
	public void testGetPatientAllergiesFromVista() {
		AllergyDataLayer dl = new AllergyDataLayerMdws(mdwsVistaConfiguration);
		DateFilter filter = DateFilterFactory.createFilterFromDate(DateHelper.parseDate("01/01/1998"), DateHelper.getToday());
		Allergies allergies = dl.fetchAllergies(createPatientIdentifier(), filter);
		
		assertNotNull(allergies);
		assertEquals(2, allergies.size());
		
		Allergy one = allergies.get(0);
		assertEquals("744", one.getUniqueId());
		assertEquals("DRUG", one.getCategory());
		assertEquals("PENICILLIN", one.getSubstance());
		
		Allergy two = allergies.get(1);
		assertEquals("867",	two.getUniqueId());
		assertEquals("DRUG, FOOD", two.getCategory());
		assertEquals("CHOCOLATE", two.getSubstance());
	}
	
    private PatientIdentifier createPatientIdentifier() {
        return new PatientIdentifier("DFN-500", "237");
    }
}
