package com.agilex.healthcare.mobilehealthplatform.datalayer.cdw.vital;

import java.util.List;

import org.junit.*;

import com.agilex.healthcare.mobilehealthplatform.datalayer.vital.*;
import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.mobilehealthplatform.domain.code.VitalSectionCode;
import com.agilex.healthcare.mobilehealthplatform.mdws.MdwsIntegrationTestHelper;

@Ignore
public class VitalDataLayerCdwTest {
	
	private final PatientIdentifier CDW_PATIENT_ICN = new PatientIdentifier("ICN", "1002772146V123456");
	static VitalDataLayerCdw dataLayer;
	
	@BeforeClass
	public static void before() {
		dataLayer = new VitalDataLayerCdw(MdwsIntegrationTestHelper.getCdwMdwsConfiguration());
	}
	
	@Test
	public void validateBasicRetrieve() {
		VitalEntries vitalEntries = dataLayer.fetchVitalEntries(CDW_PATIENT_ICN, new VitalEntryFilter());
		Assert.assertNotNull(vitalEntries);
		Assert.assertTrue(vitalEntries.size() > 0);
	}
	
	
	@Test
	public void validateBloodPressureFields() {
		
		VitalEntries vitalEntries = dataLayer.fetchVitalEntries(CDW_PATIENT_ICN, new VitalEntryFilter(VitalSectionCode.BloodPressure));
		Assert.assertNotNull(vitalEntries);
		
		VitalEntry vitalEntry = vitalEntries.get(0);
		validateRequiredFields(vitalEntry);
		
		Assert.assertTrue(vitalEntry.getVitalObservations().size() == 2);
		
		List<VitalObservation> vitalObservations = vitalEntry.getVitalObservations();
		Assert.assertTrue(vitalObservations.size() == 2);
		
		for(VitalObservation vitalObservation : vitalObservations) {
			Assert.assertTrue(vitalObservation.getValue().length() > 1);
			Assert.assertTrue(vitalObservation.getValueUnits().length() > 1);
		}
	}
	
	@Test
	public void validatePulseFields() {
		VitalEntries vitalEntries = dataLayer.fetchVitalEntries(CDW_PATIENT_ICN, new VitalEntryFilter(VitalSectionCode.Pulse));
		Assert.assertNotNull(vitalEntries);
		
		VitalEntry vitalEntry = vitalEntries.get(0);
		validateRequiredFields(vitalEntry);
		
		List<VitalObservation> vitalObservations = vitalEntry.getVitalObservations();
		Assert.assertTrue(vitalObservations.size() == 1);
		
		for(VitalObservation vitalObservation : vitalObservations) {
			Assert.assertTrue(vitalObservation.getValue().length() > 1);
			//Assert.assertTrue(vitalObservation.getValueUnits().length() > 1);
		}
	}
	
	@Test
	public void validateTemperatureFields() {
		VitalEntries vitalEntries = dataLayer.fetchVitalEntries(CDW_PATIENT_ICN, new VitalEntryFilter(VitalSectionCode.Temperature));
		Assert.assertNotNull(vitalEntries);
		
		VitalEntry vitalEntry = vitalEntries.get(0);
		validateRequiredFields(vitalEntry);
		
		List<VitalObservation> vitalObservations = vitalEntry.getVitalObservations();
		Assert.assertTrue(vitalObservations.size() == 1);
		
		for(VitalObservation vitalObservation : vitalObservations) {
			Assert.assertTrue(vitalObservation.getValue().length() > 1);
			//Assert.assertTrue(vitalObservation.getValueUnits().length() > 1);
		}
	}
	
	@Test
	public void validateRespirationFields() {
		VitalEntries vitalEntries = dataLayer.fetchVitalEntries(CDW_PATIENT_ICN, new VitalEntryFilter(VitalSectionCode.Respiration));
		Assert.assertNotNull(vitalEntries);
		
		VitalEntry vitalEntry = vitalEntries.get(0);
		validateRequiredFields(vitalEntry);
		
		List<VitalObservation> vitalObservations = vitalEntry.getVitalObservations();
		Assert.assertTrue(vitalObservations.size() == 1);
		
		for(VitalObservation vitalObservation : vitalObservations) {
			Assert.assertTrue(vitalObservation.getValue().length() > 1);
			//Assert.assertTrue(vitalObservation.getValueUnits().length() > 1);
		}
	}
	
	@Test
	public void validateHeightFields() {
		VitalEntries vitalEntries = dataLayer.fetchVitalEntries(CDW_PATIENT_ICN, new VitalEntryFilter(VitalSectionCode.Height));
		Assert.assertNotNull(vitalEntries);
		
		VitalEntry vitalEntry = vitalEntries.get(0);
		validateRequiredFields(vitalEntry);
		
		List<VitalObservation> vitalObservations = vitalEntry.getVitalObservations();
		Assert.assertTrue(vitalObservations.size() == 1);
		
		for(VitalObservation vitalObservation : vitalObservations) {
			Assert.assertTrue(vitalObservation.getValue().length() > 1);
			//Assert.assertTrue(vitalObservation.getValueUnits().length() > 1);
		}
	}
	
	@Test
	public void validateWeightFields() {
		VitalEntries vitalEntries = dataLayer.fetchVitalEntries(CDW_PATIENT_ICN, new VitalEntryFilter(VitalSectionCode.Weight));
		Assert.assertNotNull(vitalEntries);
		
		VitalEntry vitalEntry = vitalEntries.get(0);
		validateRequiredFields(vitalEntry);
		
		List<VitalObservation> vitalObservations = vitalEntry.getVitalObservations();
		Assert.assertTrue(vitalObservations.size() == 1);
		
		for(VitalObservation vitalObservation : vitalObservations) {
			Assert.assertTrue(vitalObservation.getValue().length() > 1);
			//Assert.assertTrue(vitalObservation.getValueUnits().length() > 1);
		}
	}
	
	@Test
	public void validatePulseOxFields() {
		VitalEntries vitalEntries = dataLayer.fetchVitalEntries(CDW_PATIENT_ICN, new VitalEntryFilter(VitalSectionCode.PulseOximetry));
		Assert.assertNotNull(vitalEntries);
		
		VitalEntry vitalEntry = vitalEntries.get(0);
		validateRequiredFields(vitalEntry);
		
		List<VitalObservation> vitalObservations = vitalEntry.getVitalObservations();
		Assert.assertTrue(vitalObservations.size() == 1);
		
		for(VitalObservation vitalObservation : vitalObservations) {
			Assert.assertTrue(vitalObservation.getValue().length() > 1);
			//Assert.assertTrue(vitalObservation.getValueUnits().length() > 1);
		}
	}
	
	@Test
	public void validatePainFields() {
		VitalEntries vitalEntries = dataLayer.fetchVitalEntries(CDW_PATIENT_ICN, new VitalEntryFilter(VitalSectionCode.Pain));
		Assert.assertNotNull(vitalEntries);
		
		VitalEntry vitalEntry = vitalEntries.get(0);
		validateRequiredFields(vitalEntry);
		
		List<VitalObservation> vitalObservations = vitalEntry.getVitalObservations();
		Assert.assertTrue(vitalObservations.size() == 1);
		
		for(VitalObservation vitalObservation : vitalObservations) {
			Assert.assertNotNull(vitalObservation.getValue());
			//Assert.assertTrue(vitalObservation.getValueUnits().length() > 1);
		}
	}
	
	private void validateRequiredFields(VitalEntry vitalEntry) {
		Assert.assertNotNull(vitalEntry.getDataIdentifier());
		Assert.assertNotNull(vitalEntry.getDataIdentifier().getUniqueId());
		Assert.assertNotNull(vitalEntry.getDataIdentifier().getSystemId());
		Assert.assertEquals(CDW_PATIENT_ICN.getUniqueId(), vitalEntry.getPatientId());
		Assert.assertEquals(CDW_PATIENT_ICN.getAssigningAuthority(), vitalEntry.getAssigningAuthority());
		Assert.assertNotNull(vitalEntry.getDate());
	}
	
	@Test
	public void validateRetrieveSingle() {
		
	}
}
