package com.agilex.healthcare.mobilehealthplatform.datalayer.cdw.surgery;

import org.junit.*;
import static org.junit.Assert.*;

import com.agilex.healthcare.mobilehealthplatform.datalayer.surgery.*;
import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.mobilehealthplatform.domain.code.SourceSystemCode;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilterFactory;
import com.agilex.healthcare.mobilehealthplatform.mdws.MdwsIntegrationTestHelper;

@Ignore
public class SurgeryDataLayerCdwTest {

	static SurgeryDataLayerCdw dataLayer;
	PatientIdentifier patientIdentifier = new PatientIdentifier("DFN-688", "24198");

	@BeforeClass
	public static void before() {
		dataLayer = new SurgeryDataLayerCdw(MdwsIntegrationTestHelper.getCdwRawMdwsConfiguration());
	}

	@Test
	public void validateBasicRetrieval() {
		Surgeries surgeries = dataLayer.fetchSurgeries(patientIdentifier, DateFilterFactory.createEmptyFilter());

		assertNotNull(surgeries);
		assertTrue(surgeries.size() > 0);
	}

	@Test
	public void validateSingleRetrieve() {
		Surgeries surgeries = dataLayer.fetchSurgeries(patientIdentifier, DateFilterFactory.createEmptyFilter());

		Surgery original = surgeries.get(0);
		Assert.assertNotNull(original);

		Surgery fetched = dataLayer.fetchSurgery(patientIdentifier, original.getUniqueId());

		Assert.assertNotNull(fetched);
		Assert.assertEquals(fetched.getProcedure(), original.getProcedure());
		Assert.assertEquals(fetched.getSystemId(), original.getSystemId());
		Assert.assertEquals(fetched.getProcedureDate(), original.getProcedureDate());
		Assert.assertEquals(fetched.getFacility(), original.getFacility());
	}

	@Test
	public void validateFields() {
		Surgeries surgeries = dataLayer.fetchSurgeries(patientIdentifier, DateFilterFactory.createEmptyFilter());

		Surgery surgery = surgeries.get(0);

		Assert.assertNotNull(surgery.getDataIdentifier().getUniqueId());
		Assert.assertEquals(SourceSystemCode.CDW_RAW, surgery.getDataIdentifier().getSystemId());
		Assert.assertEquals(patientIdentifier.getUniqueId(), surgery.getPatientId());
		Assert.assertEquals(patientIdentifier.getAssigningAuthority(), surgery.getAssigningAuthority());
		Assert.assertNotNull(surgery.getFacility());
		Assert.assertNotNull(surgery.getProcedure());
		Assert.assertNotNull(surgery.getProcedureDate());
	}
}
