package com.agilex.healthcare.mobilehealthplatform.datalayer.cdw.staffdirectory;

import org.junit.*;

import com.agilex.healthcare.mobilehealthplatform.datalayer.staffdirectory.StaffDirectoryDataLayerCdw;
import com.agilex.healthcare.mobilehealthplatform.domain.StaffDirectorySearchResults;
import com.agilex.healthcare.mobilehealthplatform.mdws.MdwsIntegrationTestHelper;

@Ignore
public class StaffDirectoryCdwTest {
	static StaffDirectoryDataLayerCdw dataLayer;
	
	private String REDACTED = "[REDACTED]";
	
	@BeforeClass
	public static void before() {
		dataLayer = new StaffDirectoryDataLayerCdw(MdwsIntegrationTestHelper.getCdwMdwsConfiguration());
	}
	
	@Test 
	public void validateQueryByEmail() {
		StaffDirectorySearchResults searchResults = dataLayer.searchByEmail("688", REDACTED);
		
		Assert.assertNotNull(searchResults);
		Assert.assertEquals(1, searchResults.size());
	}
	
	@Test
	public void verifyQueryByFirstAndLast() {
		StaffDirectorySearchResults searchResults = dataLayer.searchByFirstAndLastname("688", REDACTED, REDACTED);
		
		Assert.assertNotNull(searchResults);
		Assert.assertEquals(1, searchResults.size());
	}
	
	@Test
	public void verifyQueryByFirstOrLast() {
		StaffDirectorySearchResults searchResults = dataLayer.searchByFirstOrLastname("688", "", "jones");
		
		Assert.assertNotNull(searchResults);
		Assert.assertTrue(searchResults.size() >= 13);
	}
	
	@Test
	public void verifyQueryByPhone() {
		StaffDirectorySearchResults searchResults = dataLayer.searchByPhoneNumber("688", REDACTED);
		
		Assert.assertNotNull(searchResults);
		Assert.assertEquals(2, searchResults.size());
	}
}
