package com.agilex.healthcare.mobilehealthplatform.datalayer.cdw.radiology;

import org.junit.*;

import com.agilex.healthcare.mobilehealthplatform.datalayer.radiology.*;
import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.*;
import com.agilex.healthcare.mobilehealthplatform.mdws.MdwsIntegrationTestHelper;
import com.agilex.healthcare.utility.DateHelper;

import static org.junit.Assert.*;

@Ignore
public class RadiologyDataLayerCdwTest {
	
	static RadiologyDataLayerCdw dataLayer;
	PatientIdentifier patientIdentifier = new PatientIdentifier("DFN-688", "24198");
	
	@BeforeClass
	public static void before() {
		dataLayer = new RadiologyDataLayerCdw(MdwsIntegrationTestHelper.getCdwRawMdwsConfiguration());
	}

	@Test
	public void verifyBasicFetch() {
		RadiologyResults results = dataLayer.getResults(patientIdentifier, DateFilterFactory.createEmptyFilter());
		
		assertNotNull(results);
		assertTrue(results.size() >= 78);
	}
	
	@Test
	public void verifyRetrievalFromCdwWithDateFilter() {
		DateFilter filter = DateFilterFactory.createFilterFromDate(DateHelper.parseDate("01/01/1998"), DateHelper.getToday());
		
		RadiologyResults results = dataLayer.getResults(patientIdentifier, filter);
		
		assertNotNull(results);
		assertTrue(results.size() >= 34);
	}
	
	@Test
	public void verifyFields() {
		RadiologyResults results = dataLayer.getResults(patientIdentifier, DateFilterFactory.createEmptyFilter());
		
		RadiologyResult radiologyResult = results.get(0);
		
		Assert.assertNotNull(radiologyResult.getPatientIdentifier().getAssigningAuthority());
		Assert.assertNotNull(radiologyResult.getPatientIdentifier().getUniqueId());
		Assert.assertNotNull(radiologyResult.getDataIdentifier().getSystemId());
		Assert.assertNotNull(radiologyResult.getDataIdentifier().getUniqueId());
		Assert.assertNotNull(radiologyResult.getReport());
		Assert.assertNotNull(radiologyResult.getResultedDate());
		Assert.assertNotNull(radiologyResult.getTestName());
		
	}
}
