package com.agilex.healthcare.mobilehealthplatform.datalayer.cdw.provider;

import static junit.framework.Assert.*;

import java.util.*;

import org.junit.*;

import com.agilex.healthcare.mobilehealthplatform.datalayer.provider.*;
import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.*;
import com.agilex.healthcare.mobilehealthplatform.mdws.MdwsIntegrationTestHelper;
import com.agilex.healthcare.utility.DateHelper;

@Ignore
public class ProviderDataLayerCdwTest {
	
	static ProviderDataLayerCdw dataLayer;
	PatientIdentifier patientIdentifier = new PatientIdentifier("ICN", "1004893470v123456");
	
	@BeforeClass
	public static void before() {
		dataLayer = new ProviderDataLayerCdw(MdwsIntegrationTestHelper.getCdwMdwsConfiguration());
	}
	
	@Test
	public void validateBasicRetrieval() {
		PatientProviders providers = dataLayer.fetchPrimaryCareProviders(patientIdentifier, "573");
		
		Assert.assertNotNull(providers);
		Assert.assertEquals(1, providers.size());
		
		PatientProvider provider = providers.get(0);

		Assert.assertNotNull(provider.getProviderName());
		Assert.assertEquals("PHYSICIAN-PRIMARY CARE", provider.getPersonClass());
		Assert.assertNotNull(provider.getUniqueId());
		Assert.assertNotNull(provider.getProviderId());
	}

    @Test
    public void fetchMentalHealthProviders() {
    	PatientIdentifier patientIdentifier = new PatientIdentifier("ICN", "1002772146v123456");
        DateFilter filter = DateFilterFactory.createEmptyFilter();
        PatientProviders providers = dataLayer.fetchMentalHealthProviders(patientIdentifier, filter, "586");

        Assert.assertNotNull(providers);
        Assert.assertTrue(providers.size() >= 26);
    }
    
    @Test
    public void fetchMentalHealthProvidersDoesNotReturnDuplicateProviders() {

        DateFilter filter = DateFilterFactory.createEmptyFilter();

        PatientIdentifier patientIdentifier =  new PatientIdentifier("ICN", "1011969310");
        PatientProviders providers = dataLayer.fetchMentalHealthProviders(patientIdentifier, filter, "508");
        
        // Ensure the provider name has not been seen yet
        Map<String, String> providerMap = new LinkedHashMap<String, String>();
        for(PatientProvider provider : providers) {
        	String providerName = providerMap.get(provider.getProviderName());
        	Assert.assertNull(providerName);
        	providerMap.put(providerName, "");
        }
    }
    
    @Test
    public void fetchMentalHealthProvidersWithDateFilter() {
        DateFilter filter = DateFilterFactory.createFilterFromDate(DateHelper.parseDate("01/01/2005"), DateHelper.getToday());
        PatientProviders providers = dataLayer.fetchMentalHealthProviders(patientIdentifier, filter, "573");

        assertNotNull(providers);
        assertEquals(1, providers.size());

        PatientProvider providerEgan = providers.get(0);

        assertNotNull(providerEgan);
        assertEquals("EGAN,MICHAEL", providerEgan.getProviderName());
        assertEquals("", providerEgan.getPersonClass());

        Date expectedDate = DateHelper.parseDate("10/27/2005");
        assertTrue(DateHelper.areEqual(DateHelper.endOfDay(expectedDate), DateHelper.endOfDay(providerEgan.getVisitDate())));
    }


}
