package com.agilex.healthcare.mobilehealthplatform.datalayer.cdw.problem;

import junit.framework.Assert;

import org.junit.*;

import com.agilex.healthcare.mobilehealthplatform.datalayer.problem.ProblemDataLayerCdw;
import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.*;
import com.agilex.healthcare.mobilehealthplatform.mdws.MdwsIntegrationTestHelper;

@Ignore("TODO: ensure data consistency with MDWS / test vista site")
public class ProblemDataLayerCdwTest {

	static ProblemDataLayerCdw dataLayer;
	PatientIdentifier patientIdentifier = new PatientIdentifier("ICN", "1011491687V123456");

	@BeforeClass
	public static void before() {
		dataLayer = new ProblemDataLayerCdw(MdwsIntegrationTestHelper.getCdwMdwsConfiguration());
	}

	@Test
	public void validateBasicRetrieve() {
		DateFilter dateFilter = DateFilterFactory.createEmptyFilter();
		Problems problems = dataLayer.fetchProblems(patientIdentifier, dateFilter);

		Assert.assertNotNull(problems);
		Assert.assertTrue(problems.size() > 5);
	}

	@Test
	public void validateFields() {
		DateFilter dateFilter = DateFilterFactory.createEmptyFilter();
		Problems problems = dataLayer.fetchProblems(patientIdentifier, dateFilter);

		Assert.assertNotNull(problems);
		Problem problem = problems.get(0);

		Assert.assertNotNull(problem.getOnsetDate());
		Assert.assertNotNull(problem.getDescription());
		Assert.assertTrue(problem.getDescription().length() > 4);
		Assert.assertNotNull(problem.getSourceSystem());
		Assert.assertTrue(problem.getSourceSystem().length() > 4);
		Assert.assertEquals(patientIdentifier.getUniqueId(), problem.getPatientIdentifier().getUniqueId());
		Assert.assertNotNull(problem.getDataIdentifier());
		Assert.assertNotNull(problem.getDataIdentifier().getSystemId());
		Assert.assertNotNull(problem.getDataIdentifier().getUniqueId());
	}

	@Test
	public void validateRetrieveByDate() {

		DateFilter dateFilter = DateFilterFactory.createFilterFromDate("01/01/2010", "01/01/2013");
		Problems problems = dataLayer.fetchProblems(patientIdentifier, dateFilter);

		Assert.assertNotNull(problems);
		// TODO finish
	}

}
