package com.agilex.healthcare.mobilehealthplatform.datalayer.cdw.medication;

import java.util.*;

import junit.framework.Assert;

import org.junit.*;

import com.agilex.healthcare.mobilehealthplatform.datalayer.medication.*;
import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.mobilehealthplatform.mdws.MdwsIntegrationTestHelper;

@Ignore
public class MedicationDataLayerCdwTest {

	static MedicationDataLayerCdw dataLayer;
	PatientIdentifier patientIdentifier = new PatientIdentifier("ICN", "1011025716v634019");
	
	@BeforeClass
	public static void before() {
		dataLayer = new MedicationDataLayerCdw(MdwsIntegrationTestHelper.getCdwMdwsConfiguration());
	}
	
	@Test
	public void validateBasicRetrieve() {
		MedicationFilter medicationFilter = new MedicationFilter();
		Medications medications = dataLayer.getMedications(patientIdentifier, medicationFilter);
		
		Assert.assertNotNull(medications);
		Assert.assertTrue(medications.size() > 0);
	}
	
	@Test
	public void validateSingleRetrieve() {
		MedicationFilter medicationFilter = new MedicationFilter();
		Medications medications = dataLayer.getMedications(patientIdentifier, medicationFilter);
		
		Medication medication = medications.get(0);
		Medication medicationDetail = dataLayer.getMedicationDetail(patientIdentifier, medication.getUniqueId());
		
		Assert.assertNotNull(medicationDetail);
	}
	
	@Test
	public void validateRetrievalByFilter() {
		List<String> statuses = Arrays.asList("active");
		MedicationFilter medicationFilter = new MedicationFilter();
		medicationFilter.setStatuses(statuses);
		Medications medications = dataLayer.getMedications(patientIdentifier, medicationFilter);
		
		Assert.assertNotNull(medications);
		Assert.assertTrue(medications.size() >= 2);
		
		for(Medication medication : medications) {
			Assert.assertTrue("active".equalsIgnoreCase(medication.getStatus()));
		}
	}
	
	@Test
	public void validateFields() {
		MedicationFilter medicationFilter = new MedicationFilter();
		Medications medications = dataLayer.getMedications(patientIdentifier, medicationFilter);

		Medication medication = medications.get(0);
		
		Assert.assertNotNull(medication.getLastFilledDate());
//		Assert.assertNotNull(medication.getExpiredDate());
		Assert.assertTrue(medication.getDrugName().length() > 4);
		Assert.assertTrue(medication.getSig().length() > 4);
		Assert.assertNotNull(medication.getRefills());
		Assert.assertTrue(medication.getStatus().length() > 4);
		Assert.assertTrue(medication.getSourceSystem().length() >= 3);
		Assert.assertNotNull(medication.getPatientIdentifier());
		Assert.assertEquals(patientIdentifier.getUniqueId(), medication.getPatientIdentifier().getUniqueId());
		Assert.assertNotNull(medication.getDataIdentifier());
		Assert.assertNotNull(medication.getDataIdentifier().getSystemId());
		Assert.assertNotNull(medication.getDataIdentifier().getUniqueId());

	}
	
	
}
