package com.agilex.healthcare.mobilehealthplatform.datalayer.cdw.lab;

import org.junit.*;

import com.agilex.healthcare.mobilehealthplatform.datalayer.lab.ChemistryLabDataLayerCdw;
import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilterFactory;
import com.agilex.healthcare.mobilehealthplatform.mdws.MdwsIntegrationTestHelper;

@Ignore
public class ChemistryLabCdwTest {

	static ChemistryLabDataLayerCdw dataLayer;
	PatientIdentifier patientIdentifier = new PatientIdentifier("ICN", "1002772146v634019");

	@BeforeClass
	public static void before() {
		dataLayer = new  ChemistryLabDataLayerCdw(MdwsIntegrationTestHelper.getCdwMdwsConfiguration());
	}
	
	@Test
	public void validateBasicRetrieve() {
		LabResults labResults = dataLayer.getLabResults(patientIdentifier, DateFilterFactory.createEmptyFilter());
		
		Assert.assertNotNull(labResults);
		Assert.assertTrue(labResults.size() > 0);
	}
	
	@Test
	public void validateFields() {
		LabResults labResults = dataLayer.getLabResults(patientIdentifier, DateFilterFactory.createEmptyFilter());
		
		LabResult labResult = labResults.get(0);
		
		Assert.assertNotNull(labResult.getReferenceHigh());
		Assert.assertNotNull(labResult.getReferenceLow());
		Assert.assertNotNull(labResult.getResultedDate());
		Assert.assertNotNull(labResult.getValue());
//		Assert.assertNotNull(labResult.getValueUnits());
		Assert.assertNotNull(labResult.getDisplayName());
		Assert.assertNotNull(labResult.getDataIdentifier());
		Assert.assertNotNull(labResult.getTestname());
		Assert.assertNotNull(labResult.getDataIdentifier().getUniqueId());
		Assert.assertNotNull(labResult.getDataIdentifier().getSystemId());
		Assert.assertNotNull(labResult.getPatientIdentifier());
		Assert.assertNotNull(labResult.getPatientIdentifier().getAssigningAuthority());
		Assert.assertNotNull(labResult.getPatientIdentifier().getUniqueId());
	}

    
}
