package com.agilex.healthcare.mobilehealthplatform.datalayer.cdw.assessmentresult;

import org.junit.*;

import com.agilex.healthcare.mobilehealthplatform.datalayer.assessmentresult.PclAssessmentResultDataLayerCdw;
import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.mobilehealthplatform.mdws.MdwsIntegrationTestHelper;

@Ignore
public class PclAssessmentCdwTest {
	
	static PclAssessmentResultDataLayerCdw dataLayer;
	PatientIdentifier patientIdentifier = new PatientIdentifier("ICN", "1011969310v123456");
	
	@BeforeClass
	public static void before() {
		dataLayer = new PclAssessmentResultDataLayerCdw(MdwsIntegrationTestHelper.getCdwMdwsConfiguration());
	}
	
	@Test
	public void validateBasicFetch() {
		AssessmentResults results = dataLayer.fetchResultsByAssessment(patientIdentifier, null, null);
		Assert.assertNotNull(results);
		Assert.assertTrue(results.size() >= 2);
	}
	
	@Test
	public void validateFields() {
		AssessmentResults results = dataLayer.fetchResultsByAssessment(patientIdentifier, null, null);
		
		AssessmentResult assessmentResult = results.get(0);
		
		Assert.assertNotNull(assessmentResult.getAssessmentId());
		Assert.assertNotNull(assessmentResult.getDataIdentifier().getUniqueId());
		Assert.assertNotNull(assessmentResult.getDataIdentifier().getSystemId());
		Assert.assertNotNull(assessmentResult.getPatientIdentifier().getAssigningAuthority());
		Assert.assertNotNull(assessmentResult.getPatientIdentifier().getUniqueId());
		Assert.assertNotNull(assessmentResult.getDateTaken());
		Assert.assertNotNull(assessmentResult.getScore());
	}
}
