package com.agilex.healthcare.mobilehealthplatform.datalayer.cdw.allergy;

import org.junit.*;
import com.agilex.healthcare.mobilehealthplatform.datalayer.allergy.*;
import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilterFactory;
import com.agilex.healthcare.mobilehealthplatform.mdws.MdwsIntegrationTestHelper;

@Ignore
public class AllergyDataLayerCdwTest {
	
	static AllergyDataLayerCdw dataLayer;
	PatientIdentifier patientIdentifier = new PatientIdentifier("DFN-688", "574");
	
	@BeforeClass
	public static void before() {
		dataLayer = new AllergyDataLayerCdw(MdwsIntegrationTestHelper.getCdwRawMdwsConfiguration());
	}

    @Test
    public void validateBasicFetch() {
    	Allergies allergies = dataLayer.fetchAllergies(patientIdentifier, DateFilterFactory.createEmptyFilter());
    	
    	Assert.assertNotNull(allergies);
    	Assert.assertTrue(allergies.size() >= 7);
    }
    
    @Test
    public void validateFields() {
    	Allergies allergies = dataLayer.fetchAllergies(patientIdentifier, DateFilterFactory.createEmptyFilter());
    	
    	Allergy allergy = allergies.get(0);
    	
    	Assert.assertNotNull(allergy.getDataIdentifier());
    	Assert.assertNotNull(allergy.getDataIdentifier().getUniqueId());
    	Assert.assertNotNull(allergy.getDataIdentifier().getSystemId());
    	Assert.assertNotNull(allergy.getPatientIdentifier());
    	Assert.assertNotNull(allergy.getPatientIdentifier().getUniqueId());
    	Assert.assertNotNull(allergy.getPatientIdentifier().getAssigningAuthority());
    	Assert.assertNotNull(allergy.getSubstance());
    	Assert.assertNotNull(allergy.getReaction());
    	Assert.assertNotNull(allergy.getSourceSystem());
    	Assert.assertEquals(patientIdentifier.getAssigningAuthority(), allergy.getAssigningAuthority());
    	Assert.assertEquals(patientIdentifier.getUniqueId(), allergy.getPatientId());
    	
    	Assert.assertNotNull(allergy.getReaction());
    	Assert.assertNotNull(allergy.getSourceSystem());
    	Assert.assertNotNull(allergy.getSubstance());
    	Assert.assertNotNull(allergy.getOnsetDate());
    }
}
