package com.agilex.system.health.services.connection;

import java.io.IOException;
import java.net.*;

public class HttpConnection {

    private final String endPoint;
    private final int connectionTimeout;
    private final int readTimeout;
    private int code;
    private String description;

    public HttpConnection(String endPoint, int connectionTimeout, int readTimeout) {
        this.endPoint = endPoint;
        this.connectionTimeout = connectionTimeout;
        this.readTimeout = readTimeout;
    }

    public void connect() throws IOException {
        URL url =  createEndpoint();
        openConnection(url);
    }

    private URL createEndpoint() throws MalformedURLException {
            return new URL(null, endPoint, new URLStreamHandler() {
                @Override
                protected URLConnection openConnection(URL url) throws IOException {
                    URL target = new URL(url.toString());
                    URLConnection connection = target.openConnection();
                    connection.setConnectTimeout(connectionTimeout);
                    connection.setReadTimeout(readTimeout);
                    return (connection);
                }
            });
    }

    private void openConnection(URL url) throws IOException {
        HttpURLConnection conn = null;

        try {
            conn = (HttpURLConnection) url.openConnection();
            conn.setRequestMethod("GET");

            code = conn.getResponseCode();
            description = conn.getResponseMessage();
        } finally {
           disconnect(conn);
        }
    }

    private void disconnect(HttpURLConnection connection) {
        if (connection == null)
            return;

        connection.disconnect();
    }

    public int getCode() {
        return code;
    }

    public String codeDescription() {
        return description;
    }

    @Override
    public String toString() {
        return "Endpoint: " + endPoint + ", Connection Timeout: " + connectionTimeout + ", Read Timeout: " + readTimeout;
    }
}
