package com.agilex.system.health.services;

import com.agilex.system.health.*;
import com.agilex.system.health.services.connection.HttpConnection;

public class WebService implements Service {

    private String name;
    private HttpConnection connection;
    private SmokeTest test;

    public WebService(String name, String endPoint, int connectionTimeout, int readTimeout) {
        this(name, endPoint, connectionTimeout, readTimeout, null);
    }

    public WebService(String name, String endPoint, int connectionTimeout, int readTimeout, SmokeTest test) {
        this.name =  name;
        connection = new HttpConnection(endPoint, connectionTimeout, readTimeout);
        this.test = test;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public ConnectionStatus runConnectionTest() {
        ConnectionStatus status = new ConnectionStatus();
        try {
            connection.connect();
            updateStatus(status);
        } catch (Exception e) {
            updateStatus(status, e);
        }

        return status;
    }

    public void updateStatus(ConnectionStatus status) {
        if (connection.getCode() == 200)
            status.setSuccess(true);

        status.setCode(connection.getCode());
        status.setCodeDescription(connection.codeDescription());
        status.setConfiguration(connection.toString());
    }

    public void updateStatus(ConnectionStatus status, Exception e) {
        status.setException(e);
        status.setConfiguration(connection.toString());
    }

    @Override
    public SmokeTestStatus runSmokeTest() {
        if (test == null)
            return notSupportedStatus();

        return test.run();
    }

    private SmokeTestStatus notSupportedStatus() {
        SmokeTestStatus status = new SmokeTestStatus();

        status.setException(new UnsupportedOperationException("This web service is not configured to support a smoke test."));
        status.setConfiguration(connection.toString());

        return status;
    }
}
