package com.agilex.system.health.services;

import com.agilex.system.health.*;

import java.net.UnknownHostException;

public class NullService implements Service {

    private String name;

    public NullService(String serviceName) {
        name = serviceName;
    }

    @Override
    public String getName() {
        if (name == null || "".equals(name)) return "invalid name";
        return name;
    }

    @Override
    public ConnectionStatus runConnectionTest() {
        ConnectionStatus status = new ConnectionStatus();

        updateStatus(status);

        return status;
    }

    @Override
    public SmokeTestStatus runSmokeTest() {
        SmokeTestStatus status = new SmokeTestStatus();

        updateStatus(status);
        return status;
    }

    private void updateStatus(ConnectionStatus status) {
        status.setException(new UnknownHostException("Unable to find service information for " + getName() + ".  Check the HealthCheck configuration."));
    }
}
