package com.agilex.system.health.config;

import com.agilex.system.health.services.NullService;
import com.agilex.system.health.services.Service;
import com.google.common.collect.Lists;

import java.util.List;
import java.util.Map;

//Spring thing
public class HealthCheckConfiguration {

    private Map<String, Service> services;

    public HealthCheckConfiguration(Map<String, Service> services) {
        this.services = services;
    }

    //do we really need?
//    public Map<String, Service> getServices() {
//        return services;
//    }
//
//    //do we really need?
//    public void setServices(Map<String, Service> services) {
//        this.services = services;
//    }

    public List<String> serviceNames() {
        List<String> names = Lists.newArrayList();

        for (Service service : services.values()) {
            names.add(service.getName());
        }

        return names;
    }

    public Service getService(String serviceName) {
        if (services.containsKey(serviceName))
            return services.get(serviceName);
        else
            return new NullService(serviceName);
    }
}


//constructor args for WebService
//smoke test bean is the repo class with it implementing the smoke test interface

//<bean id="CustomerBean" class="com.agilex.healthadapter.healthcheck.ConnectionConfigs" lazy-init="true">
//<property name="connectionConfigs">
//<map>
//<entry key="ADR">
//<bean class="com.agilex.healthadapter.healthcheck.WebService">
//<property name="name" value="ADR" />
//<property name="endpoint" value="${adr.endPointUrl}" />
//<property name="connectionTimeout" value="${adr.connectionTimeout}" />
//<property name="readTimeout" value="${adr.readTimeout}" />
//</bean>
//</entry>
//<entry key="MDWS">
//<bean class="com.agilex.healthadapter.healthcheck.WebService">
//<property name="name" value="MDWS" />
//<property name="endpoint" value="${mdws.endPointUrl}" />
//<property name="connectionTimeout" value="${mdws.connectionTimeout}" />
//<property name="readTimeout" value="${mdws.readTimeout}" />
//</bean>
//</entry>
//<entry key="HDR">
//<bean class="com.agilex.healthadapter.healthcheck.WebService">
//<property name="name" value="HDR" />
//<property name="endpoint" value="${hdr.endPointUrl}" />
//<property name="connectionTimeout" value="${hdr.connectionTimeout}" />
//<property name="readTimeout" value="${hdr.readTimeout}" />
//</bean>
//</entry>
//<entry key="MVI">
//<bean class="com.agilex.healthadapter.healthcheck.WebService">
//<property name="name" value="MVI" />
//<property name="endpoint" value="${mvi.endPointUrl}" />
//<property name="connectionTimeout" value="${mvi.connectionTimeout}" />
//<property name="readTimeout" value="${mvi.readTimeout}" />
//</bean>
//</entry>
//</map>
//</property>
//</bean>
