package com.agilex.system.health;

import com.agilex.system.health.config.HealthCheckConfiguration;
import com.agilex.system.health.services.Service;

public class HealthCheckRunner {

    HealthCheckConfiguration config;

    public HealthCheckRunner(HealthCheckConfiguration configuration) {
        config = configuration;
    }

    public Services connectedServices() {
        return new Services(config.serviceNames());
    }

    public ConnectionStatus runConnectionTest(String serviceName) {
        Service service = config.getService(serviceName);

        return service.runConnectionTest();
    }

    public SmokeTestStatus runSmokeTest(String serviceName) {
        Service service = config.getService(serviceName);

        return service.runSmokeTest();
    }
}
