package com.agilex.system.health;

import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name = "connectionStatus")
public class ConnectionStatus {
    private boolean success;
    private int code;
    private String codeDescription;
    private String exceptionType;
    private String exceptionMessage;
    private String configuration;

    public boolean isSuccess() {
        return success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getCodeDescription() {
        return codeDescription;
    }

    public void setCodeDescription(String codeDescription) {
        this.codeDescription = codeDescription;
    }

    public String getExceptionMessage() {
        return exceptionMessage;
    }

    public void setExceptionMessage(String exceptionMessage) {
        this.exceptionMessage = exceptionMessage;
    }
    public String getExceptionType() {
        return exceptionType;
    }

    public void setExceptionType(String exceptionType) {
        this.exceptionType = exceptionType;
    }

    public void setException(Exception e) {
        Throwable t = getRootException(e);

        exceptionMessage = t.getMessage();
        exceptionType = t.getClass().getName();
    }

    private Throwable getRootException(Throwable e) {
        if (e.getCause() == null)
            return e;

        Throwable cause = e.getCause();

        while (cause.getCause() != null) {
            cause = cause.getCause();
        }

        return cause;
    }

    public String getConfiguration() {
        return configuration;
    }

    public void setConfiguration(String configuration) {
        this.configuration = configuration;
    }
}
