package com.agilex.system.health.services;

import com.agilex.system.health.ConnectionStatus;
import org.junit.Test;
import org.junit.Before;
import org.junit.Ignore;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

import static junit.framework.Assert.*;

public class WebServiceTest {
    private String HDR_ENDPOINT_URL = "";
    @Before
    public void init() {
      Properties p = new Properties();
      try {
        // note: properties file is loading from the classpath; if the int tests are being run through gradle,
        // this file can be placed at the root + /intTest/spring/properties/va-veteran-dev.int.properties
        InputStream is = ClassLoader.getSystemResourceAsStream("spring/properties/va-veteran-dev.int.properties");
        p.load(is);
        HDR_ENDPOINT_URL = p.getProperty("hdr.endPointUrl");
      } catch (IOException e) {
        HDR_ENDPOINT_URL = "http://localhost:8080/hdr/mockPathwaysHttpBinding";
      }
    }
    @Test
    public void okConnectionTest() {
        WebService service = new WebService("HDR", HDR_ENDPOINT_URL, 5000, 60000);
        ConnectionStatus status = service.runConnectionTest();
        assertEquals(200, status.getCode());
        assertEquals("OK", status.getCodeDescription());
        assertTrue(status.isSuccess());
    }

    @Ignore
    @Test
    public void notFoundConnectionTest() {
        WebService service = new WebService("HDR", "http://example.com/invalid/mockPathwaysHttpBinding", 5000, 60000);
        ConnectionStatus status = service.runConnectionTest();
        assertEquals(404, status.getCode());
        assertEquals("Not Found", status.getCodeDescription());
        assertFalse(status.isSuccess());
    }

    @Test
    public void malformedUrlConnectionTest() {
        WebService service = new WebService("HDR", "htp:ha.invalid.com:8089/hdr/mockPathwaysHttpBinding", 5000, 60000);
        ConnectionStatus status = service.runConnectionTest();
        assertFalse(status.isSuccess());
        assertEquals("java.net.MalformedURLException", status.getExceptionType());
    }

    @Test
    public void connectionTimeoutConnectionTest() {
        WebService service = new WebService("HDR", "http://hadev.invalid.com:8089/invalid/mockPathwaysHttpBinding", 100, 60000);
        ConnectionStatus status = service.runConnectionTest();
        assertFalse(status.isSuccess());
        assertEquals("java.net.SocketTimeoutException", status.getExceptionType());
    }

}
