
package com.agilex.healthcare.mobilehealthplatform.datalayer.appointment;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;

import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.datalayer.facility.FacilityPo;
import com.agilex.healthcare.mobilehealthplatform.datalayer.patient.PatientPo;
import com.agilex.healthcare.mobilehealthplatform.domain.AppointmentRequest;
import com.agilex.healthcare.mobilehealthplatform.domain.AppointmentRequestDetailCode;
import com.agilex.healthcare.mobilehealthplatform.domain.DOBDate;
import com.agilex.healthcare.mobilehealthplatform.domain.DetailCode;
import com.agilex.healthcare.mobilehealthplatform.domain.Facility;
import com.agilex.healthcare.mobilehealthplatform.domain.Patient;

public class AppointmentRequestMapperTest {


    @Test
    public void testPoToDtoMapping(){

        AppointmentRequestPo po = createValidAppointmentRequestPo();
        AppointmentRequest dto = po.create();

        assertEqualDtoPo(po, dto);

    }

    @Test
    public void testDtoToPoMapping(){

        AppointmentRequest dto = createValidAppointmentRequestDto();
        AppointmentRequestPo po = new AppointmentRequestPo(dto);

        assertEqualDtoPo(po, dto);

    }

    private void assertEqualDtoPo(AppointmentRequestPo po, AppointmentRequest dto) {
        assertEquals(po.isActiveFlag(), dto.isActiveFlag());
        assertEquals(po.getAppointmentRequestId(), dto.getAppointmentRequestId());
        assertEquals(po.getVisitType(), dto.getVisitType());
        assertEquals(po.getAppointmentType(),dto.getAppointmentType());
        assertEquals(po.getCreatedDate(), dto.getCreatedDate());
        assertEquals(po.getDeletedDate(), dto.getDeletedDate());
        assertEquals(po.getEmail(), dto.getEmail());
        assertNotNull(dto.getFacility());
        assertEquals(po.getFacility().getName(), dto.getFacility().getName());
        assertEquals(po.getOptionDate1(), dto.getOptionDate1());
        assertEquals(po.getOptionTime1(), dto.getOptionTime1());
        assertEquals(po.getOptionDate2(), dto.getOptionDate2());
        assertEquals(po.getOptionTime2(), dto.getOptionTime2());
        assertEquals(po.getOptionDate3(), dto.getOptionDate3());
        assertEquals(po.getOptionTime3(), dto.getOptionTime3());
        assertEquals(po.getPhoneNumber(), dto.getPhoneNumber());
        assertEquals(po.getLastUpdatedDate(), dto.getLastUpdatedDate());
        assertEquals(po.getStatus(), dto.getStatus());
        assertEquals(po.getId(), dto.getUniqueId());
        assertTrue(po.getBestTimetoCall().containsAll(dto.getBestTimetoCall()));
        assertEquals(po.getPurposeOfVisit(), dto.getPurposeOfVisit());
        assertEquals(po.getOtherPurposeOfVisit(), dto.getOtherPurposeOfVisit());
        assertEquals(po.getProviderId(), dto.getProviderId());
        assertEquals(po.getProviderName(), dto.getProviderName());
        assertEquals(po.getProviderPersonClass(), dto.getProviderPersonClass());
        assertEquals(po.getProviderOption(), dto.getProviderOption());
        assertEquals(po.isSecondRequest(), dto.isSecondRequest());
        assertEquals(po.getAppointmentDate(), dto.getAppointmentDate());
        assertEquals(po.getAppointmentType(), dto.getAppointmentType());
        assertNotNull(dto.getAppointmentRequestDetailCode());
        assertFalse(po.getAppointmentRequestDetailCode().isEmpty());
        assertNotNull(dto.getPatient());
        assertEquals(po.getPatient().getFirstName(), dto.getPatient().getFirstName());
        assertEquals(po.getPatient().getLastName(), dto.getPatient().getLastName());
        assertEquals(po.getPatient().getSsn(), dto.getPatient().getSsn());
        assertEquals(new DOBDate(po.getPatient().getDateOfBirth()), dto.getPatient().getDateOfBirth());
        assertEquals(po.isTextMessagingAllowed(), dto.isTextMessagingAllowed());
        assertEquals(po.getTextMessagingPhoneNumber(), dto.getTextMessagingPhoneNumber());
        assertEquals(po.isSecondRequestSubmitted(), dto.isSecondRequestSubmitted());
        assertEquals(po.isHasProviderNewMessage(), dto.isHasProviderNewMessage());
        assertEquals(po.isHasVeteranNewMessage(), dto.isHasVeteranNewMessage());
    }


    private AppointmentRequestPo createValidAppointmentRequestPo(){
        AppointmentRequestPo po = new AppointmentRequestPo();

        po.setActiveFlag(true);
        po.setAppointmentRequestId("1");
        po.setVisitType("some type");
        po.setAppointmentType("some appointment type");
        po.setCreatedDate(new Date());
        po.setDeletedDate(new Date());
        po.setEmail("email@someservice.com");
        FacilityPo fpo = new FacilityPo();
        fpo.setName("poName");
        po.setFacility(fpo);
        po.setOptionDate1("option date 1");
        po.setOptionTime1("option time 1");
        po.setOptionDate2("option date 2");
        po.setOptionTime2("option time 2");
        po.setOptionDate3("option date 3 1");
        po.setOptionTime3("option time 3");
        po.setPhoneNumber("222-222-2222");
        po.setLastUpdatedDate(new Date());
        po.setStatus("Cancelled");
        po.setId("1");

        HashSet<String> bestTimesToCall = new HashSet<String>();
        bestTimesToCall.add("new time to call");
        po.setBestTimetoCall(bestTimesToCall);
        po.setPurposeOfVisit("my purpose to visit");
        po.setOtherPurposeOfVisit("other purpose to visit");
        po.setProviderId("provider id");
        po.setProviderName("provider name");
        po.setProviderPersonClass("provider person class");
        po.setProviderOption("provider option");
        po.setSecondRequest(false);
        po.setAppointmentDate("appointment date");
        po.setAppointmentTime("appointment type");

        LinkedList<AppointmentRequestDetailCodePo> appointmentRequestDetailCode = new LinkedList<AppointmentRequestDetailCodePo>();
        AppointmentRequestDetailCodePo ardcpo = new AppointmentRequestDetailCodePo();
        ardcpo.setDetailCode(new DetailCodePo());
        appointmentRequestDetailCode.add(ardcpo);
        po.setAppointmentRequestDetailCode(appointmentRequestDetailCode);

        po.setPatient(new PatientPo());
        po.setTextMessagingAllowed(true);
        po.setTextMessagingPhoneNumber("111-111-11111");
        po.getPatient().setSsn("123-23-1234");
        po.getPatient().setDateOfBirth(new Date());
        po.getPatient().setFirstName("TestFirst");
        po.getPatient().setLastName("TestLast");

        po.setSecondRequestSubmitted(true);

        po.setHasProviderNewMessage(true);
        po.setHasVeteranNewMessage(true);

        return po;

    }

    private AppointmentRequest createValidAppointmentRequestDto(){
        AppointmentRequest dto = new AppointmentRequest();

        dto.setActiveFlag(true);
        dto.setAppointmentRequestId("1");
        dto.setVisitType("some type");
        dto.setAppointmentType("some appointment type");
        dto.setCreatedDate(new Date());
        dto.setDeletedDate(new Date());
        dto.setEmail("email@someservice.com");
        dto.setFacility(new Facility());
        dto.setOptionDate1("option date 1");
        dto.setOptionTime1("option time 1");
        dto.setOptionDate2("option date 2");
        dto.setOptionTime2("option time 2");
        dto.setOptionDate3("option date 3 1");
        dto.setOptionTime3("option time 3");
        dto.setPhoneNumber("222-222-2222");
        dto.setLastUpdatedDate(new Date());
        dto.setStatus("Cancelled");
        dto.setUniqueId("1");

        HashSet<String> bestTimesToCall = new HashSet<String>();
        bestTimesToCall.add("new time to call");
        dto.setBestTimetoCall(bestTimesToCall);
        dto.setPurposeOfVisit("my purpose to visit");
        dto.setOtherPurposeOfVisit("other purpose to visit");
        dto.setProviderId("provider id");
        dto.setProviderName("provider name");
        dto.setProviderPersonClass("provider person class");
        dto.setProviderOption("provider option");
        dto.setSecondRequest(false);
        dto.setAppointmentDate("appointment date");
        dto.setAppointmentTime("appointment type");


        LinkedList<AppointmentRequestDetailCode> appointmentRequestDetailCode = new LinkedList<AppointmentRequestDetailCode>();
        AppointmentRequestDetailCode ardc = new AppointmentRequestDetailCode();
        ardc.setDetailCode(new DetailCode());
        appointmentRequestDetailCode.add(ardc);
        dto.setAppointmentRequestDetailCode(appointmentRequestDetailCode);

        dto.setPatient(new Patient());
        dto.setTextMessagingAllowed(true);
        dto.setTextMessagingPhoneNumber("111-111-11111");
        dto.getPatient().setSsn("123-23-1234");
        dto.getPatient().setDateOfBirth(new DOBDate(new Date()));
        dto.getPatient().setFirstName("TestFirst");
        dto.getPatient().setLastName("TestLast");

        dto.setSecondRequestSubmitted(true);

        dto.setHasProviderNewMessage(true);
        dto.setHasVeteranNewMessage(true);

        return dto;

    }


}
