package com.agilex.healthcare.mobilehealthplatform.datalayer.vitals;

import javax.persistence.TypedQuery;

import com.agilex.healthcare.mobilehealthplatform.datalayer.JpaDateFilter;
import com.agilex.healthcare.mobilehealthplatform.datalayer.vital.VitalEntryFilter;

public class VitalsJpaFilter extends JpaDateFilter {
	private final String section;

	public VitalsJpaFilter(VitalEntryFilter filter, String dateField) {
		super(filter, dateField);
		this.section = filter.getSection();
	}

	@Override
	public String createFilterQueryStr(String baseQuery) {
		String queryStr = baseQuery;

		if (section != null)
			queryStr += " and section = :section";

		return super.createFilterQueryStr(queryStr);
	}

	@Override
	public void addFilterParameters(TypedQuery<?> query) {
		if (section != null)
			query.setParameter("section", section);

		super.addFilterParameters(query);
	}
}
