package com.agilex.healthcare.mobilehealthplatform.datalayer.vitals;

import javax.persistence.*;

import com.agilex.healthcare.mobilehealthplatform.datalayer.vitals.VitalEntryPo;
import com.agilex.healthcare.mobilehealthplatform.domain.VitalObservation;
import com.agilex.healthcare.mobilehealthplatform.datalayer.PersistenceObject;
import com.agilex.healthcare.mobilehealthplatform.datalayer.Transformable;
import com.agilex.healthcare.utility.NullChecker;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import org.hibernate.annotations.GenericGenerator;

@Entity
@Table(name = "VITAL_OBSERVATION")
@XStreamAlias("VitalObservation")
public class VitalObservationPo extends PersistenceObject implements Transformable<VitalObservation> {

	private static final long serialVersionUID = 3497384939338199365L;

	private String type;
	private String value;
	private String units;
	private VitalEntryPo vitalEntry;

    public VitalObservationPo() {}

    public VitalObservationPo(VitalEntryPo entry, VitalObservation dto) {
        setType(dto.getType());
        setUnits(dto.getValueUnits());
        setValue(dto.getValue());
        setId(dto.getId());
        setUserId(dto.getPatientId());
        setVitalEntry(entry);
    }

	@Id
    @GeneratedValue(generator="vital_observation_id_generator")
    @GenericGenerator(name="vital_observation_id_generator", strategy = "uuid")
    @Column(name="VITAL_OBSERVATION_ID")
	public String getId() {
		return super.getId();
	}
	
	@Column(name = "TYPE")
	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	@Column(name = "VALUE")
	public String getValue() {
		return value;
	}

	public void setValue(String value) {
		this.value = value;
	}

	@Column(name = "UNITS")
	public String getUnits() {
		return units;
	}

	public void setUnits(String units) {
		this.units = units;
	}

	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "VITAL_ENTRY_ID", nullable = false)
	public VitalEntryPo getVitalEntry() {
		return vitalEntry;
	}

	public void setVitalEntry(VitalEntryPo vitalEntry) {
		this.vitalEntry = vitalEntry;
	}
	
	@Transient
	public Integer getValueAsIntegerByType() {
		if (NullChecker.isNullish(this.value))
			return null;
		return Integer.parseInt(this.value);
	}

	@Transient
	public Double getValueAsDouble() {
		if (NullChecker.isNullish(this.value))
			return null;
		return Double.parseDouble(this.value);
	}

    @Override
    public VitalObservation create() {
        VitalObservation observation = new VitalObservation();

        observation.setId(getId());
        observation.setPatientId(getUserId());
        observation.setType(getType());
        observation.setValue(getValue());
        observation.setValueUnits(getUnits());

        return observation;
    }
}
