package com.agilex.healthcare.mobilehealthplatform.datalayer.vitals;

import com.agilex.healthcare.mobilehealthplatform.domain.*;

import com.agilex.healthcare.mobilehealthplatform.domain.code.SourceSystemCode;
import com.agilex.healthcare.mobilehealthplatform.datalayer.PersistenceObject;
import com.agilex.healthcare.mobilehealthplatform.datalayer.Transformable;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import org.hibernate.annotations.GenericGenerator;

import java.util.*;
import javax.persistence.*;

@Entity
@Table(name = VitalEntryPo.TABLE_NAME)
@XStreamAlias("VitalEntry")
public class VitalEntryPo extends PersistenceObject implements Transformable<VitalEntry> {

	private static final long serialVersionUID = 6618167229301711810L;
    public static final String TABLE_NAME = "VITAL_ENTRY";

    private String section;
	private String notes;
	private Date entryDate;
	private String qualifier;
	private List<VitalObservationPo> observations;

	public VitalEntryPo() {
	}

	public VitalEntryPo(VitalEntry dto) {
		setId(dto.getId());
		setUserId(dto.getPatientId());
		setEntryDate(dto.getEntryDate());
		setNotes(dto.getNotes());
		setSection(dto.getSection());
		setQualifier(dto.getQualifier());

		addObservations(dto);
	}

	private void addObservations(VitalEntry dto) {
		if (dto.getVitalObservations() == null)
			return;

		observations = new ArrayList<VitalObservationPo>();

		for (VitalObservation observation : dto.getVitalObservations()) {
			observations.add(new VitalObservationPo(this, observation));
		}
	}

	@Id
	@GeneratedValue(generator = "vital_entry_id_generator")
	@GenericGenerator(name = "vital_entry_id_generator", strategy = "uuid")
	@Column(name = "VITAL_ENTRY_ID")
	public String getId() {
		return super.getId();
	}

	@Column(name = "PATIENT_ID")
	public String getUserId() {
		return super.getUserId();
	}

	@Column(name = "SECTION")
	public String getSection() {
		return section;
	}

	public void setSection(String section) {
		this.section = section;
	}

	@Column(name = "NOTES")
	public String getNotes() {
		return notes;
	}

	public void setNotes(String notes) {
		this.notes = notes;
	}

	@Column(name = "ENTRY_DATE")
	public Date getEntryDate() {
		return entryDate;
	}

	public void setEntryDate(Date entryDate) {
		this.entryDate = entryDate;
	}

	@Column(name = "QUALIFIER")
	public String getQualifier() {
		return qualifier;
	}

	public void setQualifier(String qualifier) {
		this.qualifier = qualifier;
	}

	@OneToMany(cascade = CascadeType.ALL, fetch = FetchType.EAGER, mappedBy = "vitalEntry")
	public List<VitalObservationPo> getObservations() {
		return this.observations;
	}

	public void setObservations(List<VitalObservationPo> observations) {
		this.observations = observations;
	}

	@Override
	public VitalEntry create() {
		VitalEntry entry = new VitalEntry();

		entry.setEntryDate(getEntryDate());
		entry.setId(getId());
		entry.setSystemId(SourceSystemCode.REPOSITORY);
		entry.setNotes(getNotes());
		entry.setPatientId(getUserId());
		entry.setQualifier(getQualifier());
		entry.setSection(getSection());
		entry.setVitalObservations(createVitalObservationList(entry));

		return entry;
	}

	private List<VitalObservation> createVitalObservationList(VitalEntry entry) {
		if (observations == null)
			return null;

		List<VitalObservation> vitalObservations = new ArrayList<VitalObservation>();

		for (VitalObservationPo observation : observations) {
			VitalObservation o = observation.create();
			o.setVitalEntry(entry);

			vitalObservations.add(o);
		}

		return vitalObservations;
	}
}
