package com.agilex.healthcare.mobilehealthplatform.datalayer.vitals;

import javax.annotation.Resource;

import com.agilex.healthcare.mobilehealthplatform.datalayer.vital.*;
import com.agilex.healthcare.mobilehealthplatform.domain.*;

import org.springframework.stereotype.Service;

@Service
public class VitalDataLayerRepo implements VitalDataLayer {

	@Resource
	VitalDao vitalDao;

	public VitalEntry getVitalEntry(String patientId, String vitalId) {
		return vitalDao.get(patientId, vitalId);
	}

	public VitalEntries getVitalEntries(String patientId) {
		return vitalDao.get(patientId);
	}

	public VitalEntries getVitalEntries(String patientId, VitalEntryFilter filter) {
		return vitalDao.get(patientId, filter);
	}

	public VitalEntry saveVitalEntry(VitalEntry vitalEntry) {
		return vitalDao.save(vitalEntry);
	}

	public void deleteVitalEntry(VitalEntry vitalEntry) {
		vitalDao.delete(vitalEntry);
	}

	@Override
	public VitalEntries fetchVitalEntries(PatientIdentifier patientIdentifier, VitalEntryFilter filter) {
		return getVitalEntries(patientIdentifier.getUniqueId(), filter);
	}

	@Override
	public VitalEntry fetchVitalEntry(PatientIdentifier patientIdentifier, String vitalId) {
		return getVitalEntry(patientIdentifier.getUniqueId(), vitalId);
	}
}
