package com.agilex.healthcare.mobilehealthplatform.datalayer.userhistory;

import javax.persistence.*;

import org.hibernate.annotations.GenericGenerator;

import java.io.Serializable;
import java.util.Date;

@Entity
@Table(name = "USER_HISTORY")
public class UserHistoryPo implements Serializable {
    private static final long serialVersionUID = 8159179845942392504L;

    public static final String INSERT_OP = "INSERT";
    public static final String UPDATE_OP = "UPDATE";
    public static final String DELETE_OP = "DELETE";

    private String id;
    private String userId;
    private String tableName;
    private String rowId;
    private String operation = INSERT_OP;
    private Date actionDate = new Date();
    private String data;

    @Id
    @GeneratedValue(generator="user_history_id_generator")
    @GenericGenerator(name="user_history_id_generator", strategy = "uuid")
    @Column(name="ID", nullable=false)
    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Column(name="USER_ID")
    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    @Column(name="TABLE_NAME")
    public String getTableName() {
        return tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @Column(name="ROW_ID")
    public String getRowId() {
        return rowId;
    }

    public void setRowId(String rowId) {
        this.rowId = rowId;
    }

    @Column(name="OPERATION")
    public String getOperation() {
        return operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    @Column(name="ACTION_DATE")
    public Date getActionDate() {
        return actionDate;
    }

    public void setActionDate(Date actionDate) {
        this.actionDate = actionDate;
    }

    @Column(name="DATA")
    public String getData() {
        return data;
    }

    public void setData(String data) {
        this.data = data;
    }
}
