package com.agilex.healthcare.mobilehealthplatform.datalayer.trackedtool;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;

import com.agilex.healthcare.mobilehealthplatform.datalayer.Transformable;
import com.agilex.healthcare.mobilehealthplatform.datalayer.PersistenceObject;
import org.hibernate.annotations.GenericGenerator;

import com.agilex.healthcare.mobilehealthplatform.domain.ToolTrackingResult;
import com.agilex.healthcare.mobilehealthplatform.domain.code.SourceSystemCode;

@Entity
@Table(name = "TOOL_TRACKING_RESULT")
public class ToolTrackingResultPo extends PersistenceObject implements Transformable<ToolTrackingResult> {

	private static final long serialVersionUID = 2133280727946959861L;

	private String tool;
	private String frequency;
	private String usefulness;
	private String successRate;
	private Date dateTracked;

	public ToolTrackingResultPo() {
	}

	public ToolTrackingResultPo(ToolTrackingResult trackedTool) {
		setId(trackedTool.getUniqueId());
		setUserId(trackedTool.getPatientId());
		setTool(trackedTool.getTool());
		setFrequency(trackedTool.getFrequency().toString());
		setUsefulness(trackedTool.getUsefulness().toString());
		setSuccessRate(trackedTool.getSuccessRate().toString());
		
		if(trackedTool.getDateTracked() == null)
			setDateTracked(new Date());
		else 
			setDateTracked(trackedTool.getDateTracked());
	}

	@Id
	@GeneratedValue(generator = "tracked_item_id_generator")
	@GenericGenerator(name = "tracked_item_id_generator", strategy = "uuid")
	@Column(name = "TOOL_TRACKING_RESULT_ID", nullable = false)
	public String getId() {
		return super.getId();
	}

	@Column(name = "TOOL")
	public String getTool() {
		return tool;
	}

	public void setTool(String tool) {
		this.tool = tool;
	}

	@Column(name = "PATIENT_ID")
	public String getUserId() {
		return super.getUserId();
	}

	@Column(name = "FREQUENCY")
	public String getFrequency() {
		return frequency;
	}

	public void setFrequency(String frequency) {
		this.frequency = frequency;
	}

	@Column(name = "USEFULNESS")
	public String getUsefulness() {
		return usefulness;
	}

	public void setUsefulness(String usefulness) {
		this.usefulness = usefulness;
	}

	@Column(name = "SUCCESS_RATE")
	public String getSuccessRate() {
		return successRate;
	}

	public void setSuccessRate(String successRate) {
		this.successRate = successRate;
	}

	@Column(name = "DATE_TRACKED")
	public Date getDateTracked() {
		return dateTracked;
	}

	public void setDateTracked(Date dateTracked) {
		this.dateTracked = dateTracked;
	}

	@Override
	public ToolTrackingResult create() {
		ToolTrackingResult trackedItem = new ToolTrackingResult();

		trackedItem.setUniqueId(getId());
		trackedItem.setSourceSystem(SourceSystemCode.REPOSITORY);
		trackedItem.setSystemId(SourceSystemCode.REPOSITORY);
		trackedItem.setPatientId(getUserId());
		trackedItem.setFrequency(getFrequency());
		trackedItem.setDateTracked(getDateTracked());
		trackedItem.setTool(getTool());
		if(getSuccessRate() != null)
			trackedItem.setSuccessRate(Integer.parseInt(getSuccessRate()));
		if(getUsefulness() != null)
			trackedItem.setUsefulness(Integer.parseInt(getUsefulness()));
		
		return trackedItem;
	}

}
