package com.agilex.healthcare.mobilehealthplatform.datalayer.trackedtool;

import javax.annotation.Resource;

import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilterer;
import org.springframework.stereotype.Service;

import com.agilex.healthcare.mobilehealthplatform.datalayer.tooltrackingresult.ToolTrackingResultDataLayer;
import com.agilex.healthcare.mobilehealthplatform.domain.ToolTrackingResult;
import com.agilex.healthcare.mobilehealthplatform.domain.ToolTrackingResults;

@Service
public class ToolTrackingResultDataLayerRepo implements ToolTrackingResultDataLayer {

	@Resource
	ToolTrackingResultDao dao;

    @Override
    public ToolTrackingResults fetchItems(String patientId) {
        return dao.fetchTrackedTools(patientId);
    }

    @Override
    public ToolTrackingResults fetchItems(String patientId, DateFilter dateFilter) {
        ToolTrackingResults toolTrackingResults= dao.fetchTrackedTools(patientId);
        return DateFilterer.filterByDate(toolTrackingResults, dateFilter);
    }

	@Override
	public ToolTrackingResult fetchMostRecentItem(String patientId, String toolType) {
		return dao.fetchMostRecentTool(patientId, toolType);
	}

	@Override
	public ToolTrackingResult fetchItem(String patientId, String toolId) {
		return dao.fetchTool(patientId, toolId);
	}

	@Override
	public ToolTrackingResult update(ToolTrackingResult trackedTool) {
		return dao.update(trackedTool);
	}

	@Override
	public ToolTrackingResult save(ToolTrackingResult trackedTool) {
		return dao.update(trackedTool);
	}

	@Override
	public void delete(ToolTrackingResult trackedTool) {
		dao.delete(trackedTool);
	}

}
