package com.agilex.healthcare.mobilehealthplatform.datalayer.trackedtool;

import java.util.*;

import javax.persistence.TypedQuery;

import com.agilex.healthcare.mobilehealthplatform.datalayer.Transformable;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.*;

import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.mobilehealthplatform.datalayer.AbstractDao;
import com.agilex.healthcare.mobilehealthplatform.datalayer.Mapper;

@Repository
public class ToolTrackingResultDao extends AbstractDao {
	
	private static final org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(ToolTrackingResultDao.class);

    private static final String WHERE_PATIENT = "from ToolTrackingResultPo where userId = :patientId order by dateTracked desc";
	private static final String WHERE_PATIENT_AND_TOOL_NAME = "from ToolTrackingResultPo where userId = :patientId AND tool = :toolName order by dateTracked desc";
	private static final String WHERE_PATIENT_AND_TOOL_ID = "from ToolTrackingResultPo where userId = :patientId AND id = :toolId";

    public ToolTrackingResults fetchTrackedTools(String patientId) {
        TypedQuery<ToolTrackingResultPo> query = createQuery(WHERE_PATIENT);
        setParameter(query, "patientId", patientId);

        List<ToolTrackingResultPo> results = query.getResultList();

        List<Transformable<? extends DomainTransferObject>> transformableList = createTransformableList(results);
        ToolTrackingResults tools = new ToolTrackingResults();
        Mapper.add(transformableList, tools);

        return tools;
    }

    public ToolTrackingResults fetchTrackedTools(String patientId, String tool) {
		TypedQuery<ToolTrackingResultPo> query = createQuery(WHERE_PATIENT_AND_TOOL_NAME);
		setParameter(query, "patientId", patientId);
		setParameter(query, "toolName", tool);
		
		List<ToolTrackingResultPo> results = query.getResultList();
		
		List<Transformable<? extends DomainTransferObject>> transformableList = createTransformableList(results);
		ToolTrackingResults tools = new ToolTrackingResults();
		Mapper.add(transformableList, tools);
		
		return tools;
	}
	
	public ToolTrackingResult fetchMostRecentTool(String patientId, String tool) {
		TypedQuery<ToolTrackingResultPo> query = createQuery(WHERE_PATIENT_AND_TOOL_NAME);
		setParameter(query, "patientId", patientId);
		setParameter(query, "toolName", tool);
		
		List<ToolTrackingResultPo> results = query.getResultList();
		
		if(results.size() == 0)
			return null;
		
		return results.get(0).create();
	}
	
	public ToolTrackingResult fetchTool(String patientId, String toolId) {
		TypedQuery<ToolTrackingResultPo> query = createQuery(WHERE_PATIENT_AND_TOOL_ID);
		setParameter(query, "patientId", patientId);
		setParameter(query, "toolId", toolId);
		
		List<ToolTrackingResultPo> results = query.getResultList();
		
		if(results.size() == 0)
			return null;
		
		if(results.size() > 1)
			logger.warn("Retrieved more than one TrackedTool");
		
		return results.get(0).create();
	}
 	
	@Transactional(propagation = Propagation.REQUIRED)
	public ToolTrackingResult update(ToolTrackingResult tool) {
		logger.debug("Saving TrackedTool");
		
		ToolTrackingResultPo savedTool = this.entityManager.merge(new ToolTrackingResultPo(tool));
		
		logger.debug("Saved TrackedTool");
		
		return savedTool.create();
	}
	
	@Transactional(propagation = Propagation.REQUIRED)
	public void delete(ToolTrackingResult trackedTool) {
		ToolTrackingResultPo deleteMe = this.entityManager.find(ToolTrackingResultPo.class, trackedTool.getUniqueId());
		this.entityManager.remove(deleteMe);
	}
	
	
	private void setParameter(TypedQuery<ToolTrackingResultPo> query, String field, String value) {
		query.setParameter(field, value);
	}
	
	private List<Transformable<? extends DomainTransferObject>> createTransformableList(List<ToolTrackingResultPo> results) {
        List<Transformable<? extends DomainTransferObject>> transformableList = new ArrayList<Transformable<? extends DomainTransferObject>>();
        transformableList.addAll(results);

        return transformableList;
    }
	
	TypedQuery<ToolTrackingResultPo> createQuery(String queryString) {
		TypedQuery<ToolTrackingResultPo> query = entityManager.createQuery(queryString, ToolTrackingResultPo.class);
		return query;
	}
	
}
