package com.agilex.healthcare.mobilehealthplatform.datalayer.staffuserdisclaimer;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

@Entity
@Table(name = "STAFF_USER_DISCLAIMER")
public class StaffUserDisclaimerPo implements Serializable {

	private static final long serialVersionUID = 6319798499631841827L;

	StaffUserDisclaimerPKPo primaryKey;
	
	private boolean staffUserDisclaimerAccepted;
	private Date staffUserDisclaimerDate;

	public StaffUserDisclaimerPo() {}

	public StaffUserDisclaimerPo(StaffUserDisclaimerPKPo primaryKey, boolean accepted, Date dateAccepted) {
		this.primaryKey = primaryKey; 
		setStaffUserDisclaimerAccepted(accepted);
		setStaffUserDisclaimerDate(dateAccepted);
	}
	
	@Id
	public StaffUserDisclaimerPKPo getPrimaryKey() {
        return primaryKey;
    }
 
    public void setPrimaryKey(StaffUserDisclaimerPKPo primaryKey) {
    	this.primaryKey = primaryKey;
    }
    
	@Column(name = "SUD_STATE", nullable = false)
	public boolean isStaffUserDisclaimerAccepted() {
		return staffUserDisclaimerAccepted;
	}

	public void setStaffUserDisclaimerAccepted(boolean StaffUserDisclaimerAccepted) {
		this.staffUserDisclaimerAccepted = StaffUserDisclaimerAccepted;
	}

	@Column(name = "SUD_DATE", nullable = false)
	public Date getStaffUserDisclaimerDate() {
		return staffUserDisclaimerDate;
	}
	
	public void setStaffUserDisclaimerDate(Date StaffUserDisclaimerDate) {
		this.staffUserDisclaimerDate = StaffUserDisclaimerDate;
	}

}