package com.agilex.healthcare.mobilehealthplatform.datalayer.staffuserdisclaimer;

import java.io.Serializable;

import javax.persistence.Column;
import javax.persistence.Embeddable;

@Embeddable
public class StaffUserDisclaimerPKPo implements Serializable {
	private static final long serialVersionUID = 1366932949101447332L;
	String userId;
	String vistaLocation;
	
	public StaffUserDisclaimerPKPo() {}
    public StaffUserDisclaimerPKPo(String vistaLocation, String userId) {
    	this.userId = userId;
    	this.vistaLocation = vistaLocation;
    }

	@Column(name = "USER_ID", nullable = false)
    public String getUserId() {
		return userId;
	}
	public void setUserId(String userId) {
		this.userId = userId;
	}

	@Column(name = "VISTA_LOCATION", nullable = false)
    public String getVistaLocation() {
		return vistaLocation;
	}
	public void setVistaLocation(String vistaLocation) {
		this.vistaLocation = vistaLocation;
	}
	
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((userId == null) ? 0 : userId.hashCode());
		result = prime * result +  ((vistaLocation == null) ? 0 : vistaLocation.hashCode());
		
		return result;
	}
	
	@Override
	public boolean equals(Object o) {
		boolean result = false;
		if (o != null && o instanceof StaffUserDisclaimerPKPo) {
			StaffUserDisclaimerPKPo that = (StaffUserDisclaimerPKPo)o;
			
			if (this.userId == null && that.userId == null ||
				(this.userId != null) && this.userId.equals(that.userId)) {
				if (this.vistaLocation == null && that.vistaLocation == null ||
					(this.vistaLocation != null) && this.vistaLocation.equals(that.vistaLocation)) {
						result = true;
				}
			}
		}
		
		return result;
	}
}