package com.agilex.healthcare.mobilehealthplatform.datalayer.staffuserdisclaimer;

import com.agilex.healthcare.mobilehealthplatform.domain.StaffUserDisclaimerInfo;

public class StaffUserDisclaimerMapper {

	public StaffUserDisclaimerInfo toDto(StaffUserDisclaimerPo po) {
		
		StaffUserDisclaimerInfo dto = null;

		if(po != null){
			dto = new StaffUserDisclaimerInfo();
			dto.setUserId(po.getPrimaryKey().getUserId());
			dto.setVistaLocation(po.getPrimaryKey().getVistaLocation());
			dto.setStaffUserDisclaimerAccepted(po.isStaffUserDisclaimerAccepted());
			dto.setStaffUserDisclaimerDate(po.getStaffUserDisclaimerDate());
		}
		
		return dto;
	}
	
	public StaffUserDisclaimerPo toPo(StaffUserDisclaimerInfo dto) {
		StaffUserDisclaimerPo po = null;
		
		if(dto != null){
			po = new StaffUserDisclaimerPo();
			StaffUserDisclaimerPKPo primaryKey = new StaffUserDisclaimerPKPo(dto.getVistaLocation(), dto.getUserId());
			po.setPrimaryKey(primaryKey);
			po.setStaffUserDisclaimerAccepted(dto.isStaffUserDisclaimerAccepted());
			po.setStaffUserDisclaimerDate(dto.getStaffUserDisclaimerDate());
		}
		return po;
	}
}
