package com.agilex.healthcare.mobilehealthplatform.datalayer.staffuserdisclaimer;

import javax.annotation.Resource;

import com.agilex.healthcare.mobilehealthplatform.domain.StaffUserDisclaimerContent;
import com.agilex.healthcare.mobilehealthplatform.domain.StaffUserDisclaimerInfo;

public class StaffUserDisclaimerDataLayerRepo implements StaffUserDisclaimerDataLayer {

	@Resource
	StaffUserDisclaimerDao dao;
	StaffUserDisclaimerMapper mapper = new StaffUserDisclaimerMapper();
	
	public StaffUserDisclaimerDataLayerRepo() {
	}
	
	public StaffUserDisclaimerDataLayerRepo(StaffUserDisclaimerDao dao) {
		this.dao = dao;
	}

	public StaffUserDisclaimerInfo getStaffUserDisclaimerInfo(String vistaLocation, String userId) {
		StaffUserDisclaimerPo staffUserDisclaimer = dao.getStaffUserDisclaimer(vistaLocation, userId);
		return mapper.toDto(staffUserDisclaimer);
	}

	public StaffUserDisclaimerInfo saveStaffUserDisclaimerInfo(StaffUserDisclaimerInfo staffUserDisclaimerInfo) {
		StaffUserDisclaimerPo sudToSave = mapper.toPo(staffUserDisclaimerInfo);
		StaffUserDisclaimerPo savedStaffUserDisclaimer = dao.saveStaffUserDisclaimer(sudToSave);
		return mapper.toDto(savedStaffUserDisclaimer);
	}

	@Override
	public StaffUserDisclaimerContent getLatestStaffUserDisclaimerContent() {
		return dao.getLatestStaffUserDisclaimerContent();
	}

	@Override
	public StaffUserDisclaimerContent saveStaffUserDisclaimerContent(StaffUserDisclaimerContent staffUserDisclaimerContent) {
		return dao.saveStaffUserDisclaimerContent(staffUserDisclaimerContent);
	}
}
