package com.agilex.healthcare.mobilehealthplatform.datalayer.staffuserdisclaimer;


import java.util.List;

import javax.persistence.Query;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response.Status;

import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import com.agilex.healthcare.mobilehealthplatform.datalayer.AbstractDao;
import com.agilex.healthcare.mobilehealthplatform.domain.StaffUserDisclaimerContent;

@Repository
public class StaffUserDisclaimerDao extends AbstractDao {

	public StaffUserDisclaimerPo getStaffUserDisclaimer(String vistaLocation, String userId) {
		StaffUserDisclaimerPKPo primaryKey = new StaffUserDisclaimerPKPo(vistaLocation, userId);
		StaffUserDisclaimerPo po = this.entityManager.find(StaffUserDisclaimerPo.class, primaryKey);
		if (po == null) {
			throw new WebApplicationException(Status.NO_CONTENT);
		}
		return po;
	}

	@Transactional(propagation = Propagation.REQUIRED)
	public StaffUserDisclaimerPo saveStaffUserDisclaimer(StaffUserDisclaimerPo staffUserDisclaimer) {
		return this.entityManager.merge(staffUserDisclaimer);
	}

	@Transactional(propagation = Propagation.REQUIRED)
	public StaffUserDisclaimerContent saveStaffUserDisclaimerContent(StaffUserDisclaimerContent staffUserDisclaimerContent) {
		StaffUserDisclaimerContentPo po = new StaffUserDisclaimerContentPo(staffUserDisclaimerContent);
		po = this.entityManager.merge(po);
		
		return (po == null) ? null : po.create();
	}
	
	public StaffUserDisclaimerContent getLatestStaffUserDisclaimerContent() {
		String select = "from StaffUserDisclaimerContentPo order by createdDate DESC";
		Query query = getQuery(select).setMaxResults(1);

		@SuppressWarnings("unchecked")
		List<StaffUserDisclaimerContentPo> po =  (List<StaffUserDisclaimerContentPo>) query.getResultList();
		
		return (po == null || po.size() == 0) ? null : po.get(0).create();
	}

	private Query getQuery(String dbQuery) {
		Query query = this.entityManager.createQuery(dbQuery);
		return query;
	}
}
