package com.agilex.healthcare.mobilehealthplatform.datalayer.staffuserdisclaimer;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.Table;

import com.agilex.healthcare.mobilehealthplatform.domain.StaffUserDisclaimerContent;

@Entity
@Table(name = "STAFF_USER_DISCLAIMER_CONTENT")
public class StaffUserDisclaimerContentPo implements Serializable {

	private static final long serialVersionUID = 6319798499631841827L;

	private Date createdDate;
	private String content;

	public StaffUserDisclaimerContentPo() {}

	public StaffUserDisclaimerContentPo(Date date, String content) {
		this.createdDate = date;
		this.content = content;
	}
	
	public StaffUserDisclaimerContentPo(StaffUserDisclaimerContent dto) {
		this.createdDate = dto.getDate();
		this.content = dto.getContent();
	}
	
    @Id
	@Column(name = "CREATED_DATE", nullable = false)
	public Date getCreatedDate() {
		return createdDate;
	}
	
	public void setCreatedDate(Date date) {
		this.createdDate = date;
	}
	
	@Column(name = "CONTENT", nullable = false)
	@Lob
	public String getContent() {
        return content;
    }
 
    public void setContent(String content) {
    	this.content = content;
    }
    
    public StaffUserDisclaimerContent create() {
    	StaffUserDisclaimerContent dto = new StaffUserDisclaimerContent();
    	dto.setContent(content);
    	dto.setDate(createdDate);
    	
    	return dto;
    }
}