package com.agilex.healthcare.mobilehealthplatform.datalayer.rightofaccess;

import com.agilex.healthcare.mobilehealthplatform.datalayer.PersistenceObject;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

@Entity
@Table(name = "USER_RIGHTOFACCESS")
public class RightOfAccessPo extends PersistenceObject {

	private static final long serialVersionUID = 6319798499631841827L;

	private boolean rightOfAccessAccepted;
	private Date rightOfAccessDate;
	private byte[] rightOfAccessPDF;

	public RightOfAccessPo() {}

	public RightOfAccessPo(String userId, boolean accepted, Date dateAccepted, byte[] pdf) {
		setUserId(userId);
		setRightOfAccessAccepted(accepted);
		setRightOfAccessDate(dateAccepted);
		setRightOfAccessPDF(pdf);
	}

	@Id
	@Column(name = "USER_ID")
	public String getUserId() {
		return super.getUserId();
	}

	public void setUserId(String userId) {
		super.setUserId(userId);
	}

	@Column(name = "ROA_STATE")
	public boolean isRightOfAccessAccepted() {
		return rightOfAccessAccepted;
	}

	public void setRightOfAccessAccepted(boolean rightOfAccessAccepted) {
		this.rightOfAccessAccepted = rightOfAccessAccepted;
	}

	@Column(name = "ROA_DATE")
	public Date getRightOfAccessDate() {
		return rightOfAccessDate;
	}
	
	public void setRightOfAccessDate(Date rightOfAccessDate) {
		this.rightOfAccessDate = rightOfAccessDate;
	}

	@Column(name = "ROA_FORM")
	public byte[] getRightOfAccessPDF() {
		return rightOfAccessPDF;
	}

	public void setRightOfAccessPDF(byte[] rightOfAccessPDF) {
		this.rightOfAccessPDF = rightOfAccessPDF;
	}

}
