package com.agilex.healthcare.mobilehealthplatform.datalayer.rightofaccess;

import javax.annotation.Resource;

import com.agilex.healthcare.mobilehealthplatform.domain.RightOfAccessInfo;

public class RightOfAccessDataLayerRepo implements RightOfAccessDataLayer {

	@Resource
	RightOfAccessDao dao;
	RightOfAccessMapper mapper = new RightOfAccessMapper();
	
	public boolean hasAcceptedRightOfAccess(String userId) {
		return dao.hasAcceptedRightOfAccess(userId);
	}

	public RightOfAccessInfo getRightOfAccessInfo(String userId) {
		RightOfAccessPo rightOfAccess = dao.getRightOfAccess(userId);
		return mapper.toDto(rightOfAccess);
	}

	public RightOfAccessInfo saveRightOfAccessInfo(RightOfAccessInfo rightOfAccessInfo) {
		RightOfAccessPo roaToSave = mapper.toPo(rightOfAccessInfo);
		RightOfAccessPo savedRightOfAccess = dao.saveRightOfAccess(roaToSave);
		return mapper.toDto(savedRightOfAccess);
	}

}
