package com.agilex.healthcare.mobilehealthplatform.datalayer.rightofaccess;


import java.util.List;

import javax.persistence.TypedQuery;

import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import com.agilex.healthcare.mobilehealthplatform.datalayer.AbstractDao;
import com.agilex.healthcare.utility.NullChecker;

@Repository
public class RightOfAccessDao extends AbstractDao {

	public boolean hasAcceptedRightOfAccess(String userId) {
		String dbQuery = "from RightOfAccessPo roa where roa.userId = :userId and roa.rightOfAccessAccepted = true";
		RightOfAccessPo rightOfAccess = executeRightOfAccessQuery(dbQuery, userId);
		
		boolean atLeastOneResultReturned = (rightOfAccess != null);
		return atLeastOneResultReturned;
	}

	public RightOfAccessPo getRightOfAccess(String userId) {
		String dbQuery = "from RightOfAccessPo roa where roa.userId = :userId";
		return executeRightOfAccessQuery(dbQuery, userId);
	}

	@Transactional(propagation = Propagation.REQUIRED)
	public RightOfAccessPo saveRightOfAccess(RightOfAccessPo rightOfAccess) {
		return this.entityManager.merge(rightOfAccess);
	}

	private RightOfAccessPo executeRightOfAccessQuery(String dbQuery, String userId) {
		TypedQuery<RightOfAccessPo> query = this.entityManager.createQuery(dbQuery, RightOfAccessPo.class);
		query.setParameter("userId", userId);
		
		List<RightOfAccessPo> rightOfAccessAcceptedResults = query.getResultList();
		
		if(NullChecker.isNotNullish(rightOfAccessAcceptedResults)) {
			return rightOfAccessAcceptedResults.get(0);
		} else {
			return null;
		}
	}
}
