package com.agilex.healthcare.mobilehealthplatform.datalayer.preference;

import javax.annotation.Resource;

import org.springframework.stereotype.Service;
import com.agilex.healthcare.mobilehealthplatform.domain.*;

@Service
public class PatientPreferenceDataLayerRepo implements PatientPreferenceDataLayer {

	@Resource
    NotificationPreferenceDao notificationPreferenceDao;

	public PatientPreference fetchPatientPreference(PatientIdentifier patientId){		
		NotificationPreferencePo notificationPreference = notificationPreferenceDao.get(patientId.getUniqueId());		
		PatientPreference preference = notificationPreference.create();
		preference.setPatientIdentifier(patientId);
		return preference;
	}
	
	public PatientPreference updatePatientPreference(PatientPreference patientPreference){
		NotificationPreferencePo notificationPreference = notificationPreferenceDao.update(patientPreference);		
		PatientPreference preference = notificationPreference.create();
		preference.setPatientIdentifier(patientPreference.getPatientIdentifier());
		return preference;
	}
	
	public void deletePatientPreference(PatientPreference patientPreference){
		notificationPreferenceDao.delete(patientPreference);
	}
	

}
