package com.agilex.healthcare.mobilehealthplatform.datalayer.patient;

import com.agilex.healthcare.mobilehealthplatform.domain.PatientDataCollection;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientMetadata;
import com.agilex.healthcare.mobilehealthplatform.datalayer.AbstractMapper;

public class PatientMetadataMapper extends AbstractMapper<PatientMetadata, PatientDataCollection<PatientMetadata>, PatientMetadataPo> {
	
	@Override
	public PatientMetadata toDto(PatientMetadataPo po) {
		if (po != null) {
			PatientMetadata dto = new PatientMetadata();
			dto.setPatientId(po.getUserId());
			dto.setLastAppointmentRequestAccessDate(po.getLastAppointmentRequestAccessDate());
			
			return dto;
		}
		return null;
	}

	@Override
	public PatientMetadataPo toPo(PatientMetadata dto) {
		if (dto != null) {
			PatientMetadataPo po = new PatientMetadataPo();
			po.setUserId(dto.getPatientId());
			po.setLastAppointmentRequestAccessDate(dto.getLastAppointmentRequestAccessDate());
			
			return po;
		}
		return null;
	}

}
