package com.agilex.healthcare.mobilehealthplatform.datalayer.patient;

import java.util.List;

import javax.annotation.Resource;

import org.springframework.stereotype.Service;

import com.agilex.healthcare.mobilehealthplatform.domain.PatientDataCollection;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientMetadata;

@Service
public class PatientMetadataDataLayerRepo implements PatientMetadataDataLayer {
	
	private static final org.apache.commons.logging.Log LOGGER = org.apache.commons.logging.LogFactory.getLog(PatientMetadataDataLayerRepo.class);
	private PatientMetadataMapper mapper = new PatientMetadataMapper();
	
	@Resource
	private PatientMetadataDao dao;
	
	@Override
	public List<PatientMetadata> fetchPatientMetadataList() {
		PatientDataCollection<PatientMetadata> list = new PatientDataCollection<PatientMetadata>();
		return mapper.toDtoCollection(dao.getPatientMetadata(), list);
	}

	@Override
	public PatientMetadata savePatientMetadata(PatientMetadata patientMetadata) {
		PatientMetadataPo savedPatientMetadataPo = dao.savePatientMetadata(mapper.toPo(patientMetadata));
		return mapper.toDto(savedPatientMetadataPo);
	}

	@Override
	public PatientMetadata fetchPatientMetadataByPatientId(String patientId) {
		return mapper.toDto(dao.getPatientMetadata(patientId));
	}
}
