package com.agilex.healthcare.mobilehealthplatform.datalayer.patient;

import java.util.Collection;
import java.util.List;

import javax.annotation.Resource;

import org.springframework.stereotype.Service;

import com.agilex.healthcare.mobilehealthplatform.domain.Patient;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientEdipiIcn;
import com.agilex.healthcare.mobilehealthplatform.domain.Patients;

@Service
public class PatientInternalDataLayerRepo implements PatientInternalDataLayer{

	@Resource
	private PatientInternalDao dao;

	@Override
	public Patients fetchPatients() {
		return dao.getPatients();
	}

	@Override
	public Patient fetchPatientById(String patientId) {
		return dao.getPatientById(patientId);
	}

	@Override
	public Patient savePatient(Patient patient) {
		return dao.savePatient(patient);
	}

	@Override
	public void removePatient(String patientId) {
		dao.removePatient(patientId);
	}

	@Override
	public List<PatientEdipiIcn> savePatientICN(Collection<PatientEdipiIcn> patientEdipiIcns) {
		return dao.savePatientIcn(patientEdipiIcns);
	}
}
