package com.agilex.healthcare.mobilehealthplatform.datalayer.patient;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import javax.persistence.Query;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response.Status;

import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import com.agilex.healthcare.mobilehealthplatform.datalayer.AbstractDao;
import com.agilex.healthcare.mobilehealthplatform.domain.Patient;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientEdipiIcn;
import com.agilex.healthcare.mobilehealthplatform.domain.Patients;

@Repository
public class PatientInternalDao extends AbstractDao {
	private static final org.apache.commons.logging.Log LOGGER = org.apache.commons.logging.LogFactory.getLog(PatientInternalDao.class);
	private static String selectPatientIcnSQL  = "select p from PatientEdipiIcnPo p where p.edipi = :patientId and p.activeFlag = true"; 
	
	public Patients getPatients() {
		String selectPatientPosQuery = "from PatientPo order by userId";
		Query query = getQuery(selectPatientPosQuery);
		@SuppressWarnings("unchecked")
		List<PatientPo> patientPos = query.getResultList();
		
		Patients patients = new Patients();
		
		for (PatientPo po : patientPos) {
			patients.add(po.create());
		}
		
		return patients;
	}
	
	public Patient getPatientById(String patientId) {
		try {
			return this.entityManager.find(PatientPo.class, patientId).create();
		} catch (NoResultException e) {
			throw new WebApplicationException(Status.NOT_FOUND);
		} catch (NonUniqueResultException e) {
			throw new WebApplicationException(Status.PRECONDITION_FAILED);
		}
	}
	
	@Transactional(propagation = Propagation.REQUIRED)
	public Patient savePatient(Patient patient) {
		PatientPo po = this.entityManager.merge(new PatientPo(patient));
		
		return (po == null) ? null : po.create();
	}
	
	@Transactional(propagation = Propagation.REQUIRED)
	public void removePatient(String patientId) {
		PatientPo patientToRemove = this.entityManager.find(PatientPo.class, patientId);
		if (patientToRemove != null) {
			this.entityManager.remove(patientToRemove);
		}
	}

	@Transactional(propagation = Propagation.REQUIRED)
	public List<PatientEdipiIcn> savePatientIcn(Collection<PatientEdipiIcn> patientEdipiIcns) {
		LOGGER.debug("Inside savePatientIcn");
		List<PatientEdipiIcn> savedPatientEdipiIcns = new ArrayList<PatientEdipiIcn>();
		if (!patientEdipiIcns.isEmpty()) {
			LOGGER.debug("Inside savePatientIcn for patient");
			Map<String, List<String>> edipiToIcnsMap = getEdipiToIcnMap(patientEdipiIcns);
			
			Query query = getQuery(selectPatientIcnSQL);
	        query.setParameter("patientId", patientEdipiIcns.iterator().next().getEdipi());
			@SuppressWarnings("unchecked")
			List<PatientEdipiIcnPo> existingPatientEdipiIcnPos = query.getResultList();
			
			if (existingPatientEdipiIcnPos != null && !existingPatientEdipiIcnPos.isEmpty()) {
				updatePatientIcn(savedPatientEdipiIcns, edipiToIcnsMap, existingPatientEdipiIcnPos, patientEdipiIcns);
			}
			savePatientIcn(patientEdipiIcns, savedPatientEdipiIcns);
		}
		return savedPatientEdipiIcns;
	}

	private void updatePatientIcn(List<PatientEdipiIcn> savedPatientEdipiIcns, Map<String, List<String>> edipiToIcnsMap, 
					List<PatientEdipiIcnPo> existingPatientEdipiIcnPos, Collection<PatientEdipiIcn> patientEdipiIcns) {
		for (PatientEdipiIcnPo existingPatientEdipiIcnPo : existingPatientEdipiIcnPos) {
			if (edipiToIcnsMap.containsKey(existingPatientEdipiIcnPo.getEdipi())) {
				if  (!edipiToIcnsMap.get(existingPatientEdipiIcnPo.getEdipi()).contains(existingPatientEdipiIcnPo.getIcn())) {
					existingPatientEdipiIcnPo.setActiveFlag(false);
					savePatientIcn(savedPatientEdipiIcns, existingPatientEdipiIcnPo);
				} else {
					removePatientIcn(patientEdipiIcns, existingPatientEdipiIcnPo.getIcn());
				}
			}
		}
	}

	private void removePatientIcn(Collection<PatientEdipiIcn> patientEdipiIcns, String icn) {
		List<PatientEdipiIcn> edipiIcns = new ArrayList<PatientEdipiIcn>();
		edipiIcns.addAll(patientEdipiIcns);
		for (PatientEdipiIcn patientEdipiIcn : edipiIcns) {
			if(icn.equalsIgnoreCase(patientEdipiIcn.getIcn())) {
				patientEdipiIcns.remove(patientEdipiIcn);
			}
		}
		
	}

	private void savePatientIcn(List<PatientEdipiIcn> savedPatientEdipiIcns, PatientEdipiIcnPo patientEdipiIcnPo) {
		PatientEdipiIcnPo po = this.entityManager.merge(patientEdipiIcnPo);
		PatientEdipiIcn savedPatientEdipiIcn = (po == null) ? null : po.create();
		savedPatientEdipiIcns.add(savedPatientEdipiIcn);
	}

	private void savePatientIcn(Collection<PatientEdipiIcn> patientEdipiIcns, List<PatientEdipiIcn> savedPatientEdipiIcns) {
		for (PatientEdipiIcn patientEdipiIcn : patientEdipiIcns) {
			PatientEdipiIcnPo po = this.entityManager.merge(new PatientEdipiIcnPo(patientEdipiIcn));
			PatientEdipiIcn savedPatientEdipiIcn = (po == null) ? null : po.create();
			savedPatientEdipiIcns.add(savedPatientEdipiIcn);
		}
	}
	
	private Query getQuery(String dbQuery) {
		Query query = this.entityManager.createQuery(dbQuery);
		return query;
	}
	
	private Map<String, List<String>> getEdipiToIcnMap(Collection<PatientEdipiIcn> patientEdipiIcns) {
		Map<String, List<String>> edipiToIcnMap = new HashMap<String, List<String>>();
		List<String> icns = new ArrayList<String>();
		for (PatientEdipiIcn patientEdipiIcn : patientEdipiIcns) {
			icns.add(patientEdipiIcn.getIcn());
		}
		edipiToIcnMap.put(patientEdipiIcns.iterator().next().getEdipi(), icns);
		return edipiToIcnMap;
	}
	
}
